********************************************************************************
clear all
set more off
cd "C:\Users\Thomas.Pellet\OneDrive - Peterson Institute for International Economics\2017-11\JEP OB paper natural rate\Figure 4c"

********************************************************************************
********************************************************************************
							*Hysteresis project
********************************************************************************
********************************************************************************

********************************************************************************
// 1. Generate Recession Episodes	
********************************************************************************

forval nw = 4/10 {
forval ns = 3/10 {

clear all
set more off
cd "C:\Users\Thomas.Pellet\OneDrive - Peterson Institute for International Economics\2017-11\JEP OB paper natural rate\Figure 4c"

use FinalData_c225_new.dta, clear 

scalar window=`nw'
scalar wstart=`ns' 
scalar wend=4+`ns' 

keep if lngdp!=. & lnemp!=. & lnprod!=. 
*& lnwap!=. & lnlfp!=. & lnemprate!=.
drop lrgdp_point
drop if ifscode==196

********************************************************************************
*Generate quadratic trend by Country
********************************************************************************

sort ifscode date

gen datesq = date^2
gen coeff_a =.
gen coeff_b = .
gen cons=.
gen trend=.

levelsof ifscode, local(codes)

foreach i in `codes' {
reg lrgdp date datesq if ifscode==`i'

replace coeff_a = _b[date] if ifscode==`i'
replace coeff_b = _b[datesq] if ifscode==`i'

replace cons= _b[_cons] if ifscode==`i'

replace trend = coeff_a * date + coeff_b * datesq + cons if ifscode==`i'
}
********************************************************************************

run sbbq.do
gen extremum=.
levelsof ifscode, local(codes)
foreach i in `codes' {
sbbq lngdp if ifscode==`i'
replace extremum = lngdp_point if ifscode==`i'
drop lngdp_point
}

preserve
drop extremum
save Data_prov.dta, replace
restore

drop if extremum==0

*for each ifscode we should start with a peak and finish with a trough (we are only interested in recessions)
forval i=1/20 {
sort ifscode date
by ifscode: gen n1=_n
by ifscode: gen n2=_N
by ifscode: replace extremum=0 if n1==1 & extremum==-1 
by ifscode: replace extremum=0 if n1==n2 & extremum==1 
drop if extremum==0 
drop n1 n2 
}

save Data_prov_bis.dta, replace

use Data_prov.dta, clear
merge m:1 date ifscode using Data_prov_bis.dta, keepusing(extremum) nogen
replace extremum=0 if extremum==.

gen lrgdp_point=extremum 
gen lngdp_point=extremum 

sort ifscode date

save FinalData_c225_newbis.dta, replace 

sort Country date
keep ifscode Country date sdate lrgdp lrgdp_point extremum
keep if lrgdp_point!=0

	// Generate Dates for Peaks, Troughs, and Duration (for convenience duration includes peak)
	// Peaks
by Country: gen speak = sdate if lrgdp_point==1
by Country: gen strough = sdate[_n+1] if lrgdp_point==1
by Country: gen peak = date if lrgdp_point==1
by Country: gen trough = date[_n+1] if lrgdp_point==1
by Country: gen peak_gdp = lrgdp if lrgdp_point==1
by Country: gen trough_gdp = lrgdp[_n+1] if lrgdp_point==1
format peak trough %tq

	// Duration (+1 useful so peak also defined with recession dummy=1; -1 later in computations)
gen lrgdp_duration = trough - peak + 1

	// Troughs
foreach var of varlist speak strough peak trough peak_gdp trough_gdp lrgdp_duration {
replace `var' = `var'[_n-1] if lrgdp_point==-1
}
	// Generate Episodes (Country-Peak-Trough)
gen episode = Country + "-" + speak + "-" + strough
gen false_episode = trough_gdp > peak_gdp
gen drop_episode = .

	// Check those false episode
tab episode if false_episode==1
tab episode if drop_episode==1

	// Save False Episodes
preserve
keep if false_episode==1 | drop_episode==1
drop if lrgdp_point==-1
keep ifscode date Country
save FinalData_episode_false_and_drop.dta, replace
restore

	// Save Recession Episodes 
drop if lrgdp_point==-1
drop if false_episode==1
drop if drop_episode==1
drop lrgdp lrgdp_point sdate speak strough peak_gdp trough_gdp false_episode drop_episode // peak through

**New
gen included=.
replace included=0 if peak<4*window+8+1
replace included=0 if trough>225-4*wend
drop if included==0
drop included
**End New

	// Drop Episodes too close to 1960 (can't estimate trend) or 2015 (can't estimate output gap)
preserve
keep episode peak trough
gen included=1
********************************************************************************

replace included=0 if peak<4*window+8+1
replace included=0 if trough>225-4*wend  
drop peak trough
save Episode_Included.dta, replace
restore

preserve
keep episode Country peak trough ifscode
********************************************************************************

drop if peak<4*window+8+1  
drop if trough>225-4*wend

by Country: gen episodeid = _n
drop Country
save Episode_id.dta, replace
restore

drop peak trough

preserve
egen X = count(ifscode) // total number of recessions
by Country: egen Y = count(ifscode) 
egen YY = max(Y) // max recessions by country
save numbers.dta, replace

use FinalData_c225_newbis.dta, clear
merge 1:1 ifscode date using numbers.dta, keepusing(X YY) nogen
egen XX=mean(X)
egen Y=mean(YY)
drop X
drop YY
gen X = XX
gen YY = Y
drop XX
drop Y
save FinalData_c225_newbis.dta, replace
restore

egen X = count(ifscode) // total number of recessions
by Country: egen Y = count(ifscode) 
egen YY = max(Y) // max recessions by country


	// Expand each peak (as many lines as duration)
preserve
expand lrgdp_duration
sort episode
by episode: replace date = date + _n - 1

	// Dummy Recession
gen recession = 1
save FinalData_episode_recession.dta, replace
restore

	** Note1: expand each episode 100 times, and make the peak at epid=40
	** there are about 60 quarters before the peak and 40 quarters after the peak
expand 100
sort episode date
by episode: gen epid = _n
replace date = date - epid + 40

merge m:1 ifscode date using FinalData_c225_newbis.dta, keepusing(sdate year unemp Distress CPI rgdp lrgdp lrgdppc agrgdp qgrgdp creditboom systemic lngdp lnemp lnprod trend lnwap lnlfp lnemprate)
drop if _m==2
drop _m

merge m:1 ifscode date using FinalData_episode_recession.dta, keepusing(recession) nogen
sort episode date
replace recession = 0 if recession==.

gen episode_recession = substr(episode, -13,6)<=sdate & substr(episode, -6,6)>=sdate


********************************************************************************
// 2. By Episode Generate Dummies Types recession
********************************************************************************

gen before_recession_forCPI = (episode_recession[_n+1]==1|episode_recession[_n+2]==1|episode_recession[_n+3]==1|episode_recession[_n+4]==1) & episode_recession==0

by episode: egen MaxDistress = max(Distress*(episode_recession==1))
gen Type_Distress = 0 if MaxDistress==0
replace Type_Distress = 1 if MaxDistress>=1

by episode: egen MaxSystemic = max(systemic*(episode_recession==1)) // For financial crisis
gen Type_Systemic = 0 if MaxSystemic==0 | MaxSystemic==.
replace Type_Systemic = 1 if MaxSystemic==1

by episode: gen CPI_ych = 100*(CPI / CPI[_n-4] - 1)
by episode: egen ave_CPI_ych = mean(CPI_ych*(episode_recession==1))
by episode: egen bef_CPI_ych = mean(CPI_ych*(before_recession_forCPI==1))
gen Type_Inflation = 1 if ave_CPI_ych > bef_CPI_ych
replace Type_Inflation = 0 if ave_CPI_ych <= bef_CPI_ych


by episode: gen Oilprice = 1 if (year>=1974&year<=1976)|(year>=1979&year<=1982)
by episode: egen MaxOilprice = max(Oilprice*(episode_recession==1))
gen Type_Oilprice = 1 if MaxOilprice == 1
replace Type_Oilprice = 0 if Type_Oilprice==.

preserve
keep if epid==40
keep episode lrgdp_duration Type_Distress Type_Systemic Type_Inflation Type_Oilprice 
gen lgdp_duration = lrgdp_duration - 1
merge 1:1 episode using Typesofrecession_new_temp.dta, nogen  // Table from the BCS online appendix
save Type_recession.dta, replace
restore


********************************************************************************
// 3. By Episode generate Extrapolation Starting Point and Linear Growth Trend
********************************************************************************

	** Note2: the peak's epid is at 40
sort episode date
	// Dummy peak episode
by episode: gen before0y = 1 if substr(episode, -13,6)==sdate
sort episode epid
	
	// Dummy for 8 quarters before peak (t0-9;t0-1)
by episode: gen period2yb = 1 if epid>=41 & epid<49

by episode: gen period4y_unadj_temp = epid if period2yb[_n-1]==1 & period2yb[_n+1]==.
by episode: egen period4y_unadj_start = max(period4y_unadj_temp)

by episode: gen period4y_unadj = 1 if epid>=period4y_unadj_start & epid<period4y_unadj_start + 4*window
by episode: gen cb_adj_start = 0

**Starting point is now at center of estimation window

by episode: gen start_extra = 1 if substr(episode, -13,6) == sdate[_n- 8 - 2*window - cb_adj_start]

	// Important note: Variable called period4y_unadj in all cases for simplicity

sort episode date

gen alpha = .
gen beta = .
gen stderror = .

	// Decomposition GDP, EMP, PROD
gen alphagdp = .
gen betagdp = .
gen stderrorgdp = .
gen alphaemp = .
gen betaemp = .
gen stderroremp = .
gen alphaprod = .
gen betaprod = .
gen stderrorprod = .

gen alphatrend = .
gen betatrend = .
gen stderrortrend = .

	// Decomposition WAP (working age population), LFP (labor force participation), EMPRATE (employment rate)
gen alphawap = .
gen betawap = .
gen stderrorwap = .
gen alphalfp = .
gen betalfp = .
gen stderrorlfp = .
gen alphaemprate = .
gen betaemprate = .
gen stderroremprate = .

	// Beta date
egen episodeid = group(episode) 
forval i = 1 / 170 { 
tab episode if episodeid==`i'
sum lrgdp if episodeid==`i' & period4y_unadj==1

if r(N) >=4*window {

reg lrgdp date if episodeid==`i' & period4y_unadj==1
matrix v = e(V)
replace alpha = _b[_cons] if episodeid==`i'
replace beta = _b[date] if episodeid==`i'
replace stderror = sqrt(v[1,1]) if episodeid==`i'

reg trend date if episodeid==`i' & period4y_unadj==1
matrix v = e(V)
replace alphatrend = _b[_cons] if episodeid==`i'
replace betatrend = _b[date] if episodeid==`i'
replace stderrortrend = sqrt(v[1,1]) if episodeid==`i'

}
else {
replace alpha = . if episodeid==`i'
replace beta = . if episodeid==`i'
replace stderror = . if episodeid==`i'

replace alphatrend = . if episodeid==`i'
replace betatrend = . if episodeid==`i'
replace stderrortrend = . if episodeid==`i'
}
}


********************************************************************************
preserve
gen diffbeta=.
gen testbeta=.
sort episodeid epid
by episodeid: egen databeta = min(beta)
by episodeid: egen trendbeta = min(betatrend)
by episodeid: replace diffbeta = databeta - trendbeta
keep if epid==40
keep episodeid Country episode beta betatrend databeta trendbeta diffbeta testbeta lrgdp trend
replace testbeta=1 if diffbeta>0
replace testbeta=-1 if diffbeta<0
replace testbeta=0 if diffbeta==0
gen A = diffbeta/ trendbeta*100
gen B = lrgdp - trend
drop if Country=="New Zealand"
replace testbeta=. if beta==.
save Trendtestdata.dta, replace
restore
********************************************************************************


// Decomposition GDP, EMP, PROD
forval i = 1 / 170 { 
tab episode if episodeid==`i'
sum lngdp if episodeid==`i' & period4y_unadj==1


if r(N) >=4*window {
reg lngdp date if episodeid==`i' & period4y_unadj==1
matrix v = e(V)
replace alphagdp = _b[_cons] if episodeid==`i'
replace betagdp = _b[date] if episodeid==`i'
replace stderrorgdp = sqrt(v[1,1]) if episodeid==`i'
}
else {
replace alphagdp = . if episodeid==`i'
replace betagdp = . if episodeid==`i'
replace stderrorgdp = . if episodeid==`i'
}
}
forval i = 1 / 170 {
tab episode if episodeid==`i'
sum lnemp if episodeid==`i' & period4y_unadj==1

if r(N) >=4*window {
reg lnemp date if episodeid==`i' & period4y_unadj==1
matrix v = e(V)
replace alphaemp = _b[_cons] if episodeid==`i'
replace betaemp = _b[date] if episodeid==`i'
replace stderroremp = sqrt(v[1,1]) if episodeid==`i'
}
else {
replace alphaemp = . if episodeid==`i'
replace betaemp = . if episodeid==`i'
replace stderroremp = . if episodeid==`i'
}
}
forval i = 1 / 170 {
tab episode if episodeid==`i'
sum lnprod if episodeid==`i' & period4y_unadj==1


if r(N) >=4*window {
reg lnprod date if episodeid==`i' & period4y_unadj==1
matrix v = e(V)
replace alphaprod = _b[_cons] if episodeid==`i'
replace betaprod = _b[date] if episodeid==`i'
replace stderrorprod = sqrt(v[1,1]) if episodeid==`i'
}
else {
replace alphaprod = . if episodeid==`i'
replace betaprod = . if episodeid==`i'
replace stderrorprod = . if episodeid==`i'
}
}

	// Decomposition WAP (working age population), LFP (labor force participation), EMPRATE (employment rate)
forval i = 1 / 170 { 
tab episode if episodeid==`i'
sum lnwap if episodeid==`i' & period4y_unadj==1


if r(N) >=4*window {
reg lnwap date if episodeid==`i' & period4y_unadj==1
matrix v = e(V)
replace alphawap = _b[_cons] if episodeid==`i'
replace betawap = _b[date] if episodeid==`i'
replace stderrorwap = sqrt(v[1,1]) if episodeid==`i'
}
else {
replace alphawap = . if episodeid==`i'
replace betawap = . if episodeid==`i'
replace stderrorwap = . if episodeid==`i'
}
}
forval i = 1 / 170 {
tab episode if episodeid==`i'
sum lnlfp if episodeid==`i' & period4y_unadj==1

if r(N) >=4*window {
reg lnlfp date if episodeid==`i' & period4y_unadj==1
matrix v = e(V)
replace alphalfp = _b[_cons] if episodeid==`i'
replace betalfp = _b[date] if episodeid==`i'
replace stderrorlfp = sqrt(v[1,1]) if episodeid==`i'
}
else {
replace alphalfp = . if episodeid==`i'
replace betalfp = . if episodeid==`i'
replace stderrorlfp = . if episodeid==`i'
}
}
forval i = 1 / 170 {
tab episode if episodeid==`i'
sum lnemprate if episodeid==`i' & period4y_unadj==1

if r(N) >=4*window {
reg lnemprate date if episodeid==`i' & period4y_unadj==1
matrix v = e(V)
replace alphaemprate = _b[_cons] if episodeid==`i'
replace betaemprate = _b[date] if episodeid==`i'
replace stderroremprate = sqrt(v[1,1]) if episodeid==`i'
}
else {
replace alphaemprate = . if episodeid==`i'
replace betaemprate = . if episodeid==`i'
replace stderroremprate = . if episodeid==`i'
}
}	

	// period4y_regrowth = linear trend 
gen period4y_regrowth = beta
gen period4y_regstd = stderror

gen period4y_regrowth_trend = betatrend
gen period4y_regstd_trend = stderrortrend

	// Decomposition GDP, EMP, PROD
gen period4y_regrowthgdp = betagdp
gen period4y_regstdgdp = stderrorgdp
gen period4y_regrowthemp = betaemp
gen period4y_regstdemp = stderroremp
gen period4y_regrowthprod = betaprod
gen period4y_regstdprod = stderrorprod

	// Decomposition WAP (working age population), LFP (labor force participation), EMPRATE (employment rate)gen period4y_regrowthgdp = betagdp
gen period4y_regrowthwap = betawap
gen period4y_regstdwap = stderrorwap
gen period4y_regrowthlfp = betalfp
gen period4y_regstdlfp = stderrorlfp
gen period4y_regrowthemprate = betaemprate
gen period4y_regstdemprate = stderroremprate


by episode: egen period4y_unemp = mean(period4y_unadj*unemp)

save FinalData_GDP_fixed_new24.dta, replace



********************************************************************************
// 4. Assembly recessions by column, one line by country, file 'i' corresponds to the i-th recession over the sample for each country
********************************************************************************

set more off
use FinalData_GDP_fixed_new24.dta, clear

	// Reminder: Before0y is a Dummy for each peak by episode (ie within 100 repetitions)
keep if before0y==1

gen episode_duration = lrgdp_duration

keep Country ifscode episode episode_duration cb_adj_start period4y_regrowth_trend period4y_regstd_trend period4y_regrowth period4y_regstd period4y_unemp period4y_regrowthgdp period4y_regstdgdp period4y_regrowthemp period4y_regstdemp period4y_regrowthprod period4y_regstdprod period4y_regrowthwap period4y_regstdwap period4y_regrowthlfp period4y_regstdlfp period4y_regrowthemprate period4y_regstdemprate X YY
sort Country

	// Recession Episodes by country (Numid is the ID for an episode by country)
by Country: gen Numid = _n
forval i = 1/`=YY[1]' {
local j = `i' - 1
by Country: gen episode`i' = episode[_n+`j']
by Country: gen episode_duration`i' = episode_duration[_n+`j']
by Country: gen cb_adj_start`i' = cb_adj_start[_n+`j']

by Country: gen period4y_regrowth`i' = period4y_regrowth[_n+`j']
by Country: gen period4y_regstd`i' = period4y_regstd[_n+`j']

by Country: gen period4y_regrowth_trend`i' = period4y_regrowth_trend[_n+`j']
by Country: gen period4y_regstd_trend`i' = period4y_regstd_trend[_n+`j']

by Country: gen period4y_regrowthgdp`i' = period4y_regrowthgdp[_n+`j']
by Country: gen period4y_regstdgdp`i' = period4y_regstdgdp[_n+`j']
by Country: gen period4y_regrowthemp`i' = period4y_regrowthemp[_n+`j']
by Country: gen period4y_regstdemp`i' = period4y_regstdemp[_n+`j']
by Country: gen period4y_regrowthprod`i' = period4y_regrowthprod[_n+`j']
by Country: gen period4y_regstdprod`i' = period4y_regstdprod[_n+`j']

by Country: gen period4y_regrowthwap`i' = period4y_regrowthwap[_n+`j']
by Country: gen period4y_regstdwap`i' = period4y_regstdwap[_n+`j']
by Country: gen period4y_regrowthlfp`i' = period4y_regrowthlfp[_n+`j']
by Country: gen period4y_regstdlfp`i' = period4y_regstdlfp[_n+`j']
by Country: gen period4y_regrowthemprate`i' = period4y_regrowthemprate[_n+`j']
by Country: gen period4y_regstdemprate`i' = period4y_regstdemprate[_n+`j']

by Country: gen period4y_unemp`i' = period4y_unemp[_n+`j']
}

	// One line by Country, all episodes for a given Country appear on the same line (Numid==1)
keep if Numid==1
forval i = 1/`=YY[1]' {
preserve

keep ifscode Country episode`i' episode_duration`i' cb_adj_start`i' period4y_regrowth`i' period4y_regstd`i' period4y_regrowth_trend`i' period4y_regstd_trend`i'  period4y_unemp`i' period4y_regrowthgdp`i' period4y_regstdgdp`i' period4y_regrowthemp`i' period4y_regstdemp`i' period4y_regrowthprod`i' period4y_regstdprod`i' period4y_regrowthwap`i' period4y_regstdwap`i'  period4y_regrowthlfp`i' period4y_regstdlfp`i'  period4y_regrowthemprate`i' period4y_regstdemprate`i' 
drop if episode`i'==""
	
	// so we can have 8+8=16 quarters before, the peak at date t=9+8=17, and 50 quarters after (enough to compute output gaps, adjusted to 100)
expand 100 + 2*window + cb_adj_start`i'


sort episode`i'
by episode`i': gen id`i' = _n
	// id'i' = 1 : start extrapolation
	
gen year = substr(episode`i',-13,4)
gen quarter = substr(episode`i',-8,1)
destring year quarter, replace
gen date = yq(year, quarter)


//As we used expand, the only date was the peak one, as we want peak in t=17+ cb_adj_start`i' we have -17-cb_adj_start`i' at the end of the formula
replace date = date + id`i' - (8+1+2*window) - cb_adj_start`i'

format date %tq
drop year quarter
save FinalData_GDP_fixed_new24_temp`i'.dta, replace
restore
}



********************************************************************************
// 5. Compute quadratic coefficients for each country
********************************************************************************

use FinalData_c225_newbis.dta, clear
merge m:1 ifscode date using FinalData_episode_recession.dta, keepusing(recession X YY) nogen
replace recession = 0 if recession==.
drop if Country=="Czech Republic"|Country=="Estonia"|Country=="Israel"|Country=="Korea, Republic of"|Country=="Slovak Republic"|Country=="Slovenia"

sort ifscode date
*gen datesq = date^2
gen coeff_c = .
gen coeff_cp = .

gen coeff_cgdp = .
gen coeff_cpgdp = .
gen coeff_cemp = .
gen coeff_cpemp = .
gen coeff_cprod = .
gen coeff_cpprod = .

gen coeff_cwap = .
gen coeff_cpwap = .
gen coeff_clfp = .
gen coeff_cplfp = .
gen coeff_cemprate = .
gen coeff_cpemprate = .


levelsof ifscode, local(codes)

foreach i in `codes' {
reg lrgdp date datesq if ifscode==`i'
replace coeff_c = _b[datesq] if ifscode==`i'
test _b[datesq]=0
replace coeff_cp = r(p) if ifscode==`i'

reg lngdp date datesq if ifscode==`i'
replace coeff_cgdp = _b[datesq] if ifscode==`i'
test _b[datesq]=0
replace coeff_cpgdp = r(p) if ifscode==`i'

reg lnemp date datesq if ifscode==`i'
replace coeff_cemp = _b[datesq] if ifscode==`i'
test _b[datesq]=0
replace coeff_cpemp = r(p) if ifscode==`i'

reg lnprod date datesq if ifscode==`i'
replace coeff_cprod = _b[datesq] if ifscode==`i'
test _b[datesq]=0
replace coeff_cpprod = r(p) if ifscode==`i'

reg lnwap date datesq if ifscode==`i'
replace coeff_cwap = _b[datesq] if ifscode==`i'
test _b[datesq]=0
replace coeff_cpwap = r(p) if ifscode==`i'

reg lnlfp date datesq if ifscode==`i'
replace coeff_clfp = _b[datesq] if ifscode==`i'
test _b[datesq]=0
replace coeff_cplfp = r(p) if ifscode==`i'

reg lnemprate date datesq if ifscode==`i'
replace coeff_cemprate = _b[datesq] if ifscode==`i'
test _b[datesq]=0
replace coeff_cpemprate = r(p) if ifscode==`i'

}


*Drops adjustment if increases extrapolated GDP trend (conservative option)
replace coeff_c = . if coeff_c>0
replace coeff_cgdp = . if coeff_cgdp>0
replace coeff_cemp = . if coeff_cgdp>0
replace coeff_cprod = . if coeff_cgdp>0

replace coeff_cwap = . if coeff_cgdp>0
replace coeff_clfp = . if coeff_cgdp>0
replace coeff_cemprate = . if coeff_cgdp>0


preserve
keep if year==2000 & quarter==1
keep Country coeff_cgdp coeff_cemp coeff_cprod coeff_cwap coeff_clfp coeff_cemprate
save CountryQuadraticCoeff.dta, replace
restore



********************************************************************************
// 6. Compute quadratic adjustment
********************************************************************************

forval i = 1/`=YY[1]' {

merge 1:1 ifscode date using FinalData_GDP_fixed_new24_temp`i'.dta, keepusing(episode`i' episode_duration`i' id`i' cb_adj_start`i' period4y_regrowth`i' period4y_regstd`i' period4y_regrowth_trend`i' period4y_regstd_trend`i' period4y_regrowthgdp`i' period4y_regstdgdp`i' period4y_regrowthemp`i' period4y_regstdemp`i' period4y_regrowthprod`i' period4y_regstdprod`i' period4y_regrowthwap`i' period4y_regstdwap`i' period4y_regrowthlfp`i' period4y_regstdlfp`i' period4y_regrowthemprate`i' period4y_regstdemprate`i')
drop if _m==2
drop _m
erase FinalData_GDP_fixed_new24_temp`i'.dta
sort episode`i' date

	//NEW: newt is equal to 1 at trough point (reminder: id is equal to 1 at the start of the extrapolation)
	
gen newt`i' = id`i' - (episode_duration`i'- 1) - cb_adj_start`i' - (8+2*window) 

	// Episode duration - 1 to wash out the +1 previously used 
gen rest`i' = episode_duration`i'-1 //new to calculate as function of the fall

by episode`i': gen adjustedgap2`i' = coeff_c*(-1)*((id`i'-1)^2)
by episode`i': gen adjustedgapgdp2`i' = coeff_cgdp*(-1)*((id`i' - 1 )^2)
by episode`i': gen adjustedgapemp2`i' = coeff_cemp*(-1)*((id`i' - 1 )^2)
by episode`i': gen adjustedgapprod2`i' = coeff_cprod*(-1)*((id`i' - 1 )^2)	

by episode`i': gen adjustedgapwap2`i' = coeff_cwap*(-1)*((id`i'-1 )^2)
by episode`i': gen adjustedgaplfp2`i' = coeff_clfp*(-1)*((id`i'-1 )^2)
by episode`i': gen adjustedgapemprate2`i' = coeff_cemprate*(-1)*((id`i'-1 )^2)

replace adjustedgap2`i' = 0 if adjustedgap2`i'==.

replace adjustedgapgdp2`i' = 0 if adjustedgapgdp2`i'==.
replace adjustedgapemp2`i' = 0 if adjustedgapemp2`i'==.
replace adjustedgapprod2`i' = 0 if adjustedgapprod2`i'==.

replace adjustedgapwap2`i' = 0 if adjustedgapwap2`i'==.
replace adjustedgaplfp2`i' = 0 if adjustedgaplfp2`i'==.
replace adjustedgapemprate2`i' = 0 if adjustedgapemprate2`i'==.



********************************************************************************
// 7. Extrapolations with and without quadratic adjustment
********************************************************************************

	// Linear +/- 1std
by episode`i': gen extrapolate_reglrgdp`i' = lrgdp if id`i'==1
by episode`i': replace extrapolate_reglrgdp`i' = extrapolate_reglrgdp`i'[_n-1] + period4y_regrowth`i' if extrapolate_reglrgdp`i'==. & id`i'>1 & newt`i'<4*wend+2 //modif 

by episode`i': gen extrapolate_reglrgdp_trend`i' = lrgdp if id`i'==1
by episode`i': replace extrapolate_reglrgdp_trend`i' = extrapolate_reglrgdp_trend`i'[_n-1] + period4y_regrowth_trend`i' if extrapolate_reglrgdp_trend`i'==. & id`i'>1 & newt`i'<4*wend+2 //modif  

by episode`i': gen extrapolate_reglrgdpU`i' = lrgdp if id`i'==1
by episode`i': replace extrapolate_reglrgdpU`i' = extrapolate_reglrgdpU`i'[_n-1] + (period4y_regrowth`i' + period4y_regstd`i') if extrapolate_reglrgdpU`i'==. & id`i'>1 & newt`i'<4*wend+2 //modif 
by episode`i': gen extrapolate_reglrgdpL`i' = lrgdp if id`i'==1
by episode`i': replace extrapolate_reglrgdpL`i' = extrapolate_reglrgdpL`i'[_n-1] + (period4y_regrowth`i' - period4y_regstd`i') if extrapolate_reglrgdpL`i'==. & id`i'>1 & newt`i'<4*wend+2 //modif 

by episode`i': gen extrapolate_reglngdp`i' = lngdp if id`i'==1
by episode`i': replace extrapolate_reglngdp`i' = extrapolate_reglngdp`i'[_n-1] + period4y_regrowthgdp`i' if extrapolate_reglngdp`i'==. & id`i'>1 & newt`i'<4*wend+2 //modif 
by episode`i': gen extrapolate_reglngdpU`i' = lngdp if id`i'==1
by episode`i': replace extrapolate_reglngdpU`i' = extrapolate_reglngdpU`i'[_n-1] + (period4y_regrowthgdp`i' + period4y_regstdgdp`i') if extrapolate_reglngdpU`i'==. & id`i'>1 & newt`i'<4*wend+2 //modif 
by episode`i': gen extrapolate_reglngdpL`i' = lngdp if id`i'==1
by episode`i': replace extrapolate_reglngdpL`i' = extrapolate_reglngdpL`i'[_n-1] + (period4y_regrowthgdp`i' - period4y_regstdgdp`i') if extrapolate_reglngdpL`i'==. & id`i'>1 & newt`i'<4*wend+2 //modif 

by episode`i': gen extrapolate_reglnemp`i' = lnemp if id`i'==1
by episode`i': replace extrapolate_reglnemp`i' = extrapolate_reglnemp`i'[_n-1] + period4y_regrowthemp`i' if extrapolate_reglnemp`i'==. & id`i'>1 & newt`i'<4*wend+2 //modif 
by episode`i': gen extrapolate_reglnempU`i' = lnemp if id`i'==1
by episode`i': replace extrapolate_reglnempU`i' = extrapolate_reglnempU`i'[_n-1] + (period4y_regrowthemp`i' + period4y_regstdemp`i') if extrapolate_reglnempU`i'==. & id`i'>1 & newt`i'<4*wend+2 //modif 
by episode`i': gen extrapolate_reglnempL`i' = lnemp if id`i'==1
by episode`i': replace extrapolate_reglnempL`i' = extrapolate_reglnempL`i'[_n-1] + (period4y_regrowthemp`i' - period4y_regstdemp`i') if extrapolate_reglnempL`i'==. & id`i'>1 & newt`i'<4*wend+2 //modif 

by episode`i': gen extrapolate_reglnprod`i' = lnprod if id`i'==1
by episode`i': replace extrapolate_reglnprod`i' = extrapolate_reglnprod`i'[_n-1] + period4y_regrowthprod`i' if extrapolate_reglnprod`i'==. & id`i'>1 & newt`i'<4*wend+2 //modif 
by episode`i': gen extrapolate_reglnprodU`i' = lnprod if id`i'==1
by episode`i': replace extrapolate_reglnprodU`i' = extrapolate_reglnprodU`i'[_n-1] + (period4y_regrowthprod`i' + period4y_regstdprod`i') if extrapolate_reglnprodU`i'==. & id`i'>1 & newt`i'<4*wend+2 //modif 
by episode`i': gen extrapolate_reglnprodL`i' = lnprod if id`i'==1
by episode`i': replace extrapolate_reglnprodL`i' = extrapolate_reglnprodL`i'[_n-1] + (period4y_regrowthprod`i' - period4y_regstdprod`i') if extrapolate_reglnprodL`i'==. & id`i'>1 & newt`i'<4*wend+2 //modif 


by episode`i': gen extrapolate_reglnwap`i' = lnwap if id`i'==1
by episode`i': replace extrapolate_reglnwap`i' = extrapolate_reglnwap`i'[_n-1] + period4y_regrowthwap`i' if extrapolate_reglnwap`i'==. & id`i'>1 & newt`i'<4*wend+2 //modif 
by episode`i': gen extrapolate_reglnlfp`i' = lnlfp if id`i'==1
by episode`i': replace extrapolate_reglnlfp`i' = extrapolate_reglnlfp`i'[_n-1] + period4y_regrowthlfp`i' if extrapolate_reglnlfp`i'==. & id`i'>1 & newt`i'<4*wend+2 //modif 
by episode`i': gen extrapolate_reglnemprate`i' = lnemprate if id`i'==1
by episode`i': replace extrapolate_reglnemprate`i' = extrapolate_reglnemprate`i'[_n-1] + period4y_regrowthemprate`i' if extrapolate_reglnemprate`i'==. & id`i'>1 & newt`i'<4*wend+2 //modif 



	//Quadratic
by episode`i': gen extrapolate_reglngdpA`i' = extrapolate_reglngdp`i' - adjustedgapgdp2`i' if id`i'>1 & newt`i'<4*wend+2 //modif  
by episode`i': gen extrapolate_reglrgdpA`i' = extrapolate_reglrgdp`i' - adjustedgap2`i' if id`i'>1 & newt`i'<4*wend+2 //modif  
by episode`i': gen extrapolate_reglrgdpA_trend`i' = extrapolate_reglrgdp_trend`i' - adjustedgap2`i' if id`i'>1 & newt`i'<4*wend+2 //modif  

by episode`i': gen extrapolate_reglnempA`i' = extrapolate_reglnemp`i' - adjustedgapemp2`i' if id`i'>1 & newt`i'<4*wend+2 //modif  
by episode`i': gen extrapolate_reglnprodA`i' = extrapolate_reglnprod`i' - adjustedgapprod2`i' if id`i'>1 & newt`i'<4*wend+2 //modif  

by episode`i': gen extrapolate_reglnwapA`i' = extrapolate_reglnwap`i' - adjustedgapwap2`i' if id`i'>1 & newt`i'<4*wend+2 //modif  
by episode`i': gen extrapolate_reglnlfpA`i' = extrapolate_reglnlfp`i' - adjustedgaplfp2`i' if id`i'>1 & newt`i'<4*wend+2 //modif  
by episode`i': gen extrapolate_reglnemprateA`i' = extrapolate_reglnemprate`i' - adjustedgapemprate2`i' if id`i'>1 & newt`i'<4*wend+2 //modif  


********************************************************************************
// 8. Gaps
********************************************************************************


//NEW
	//Difference between estimated trend and actual
by episode`i': gen extrapolate_simpdiff`i' = -1*(extrapolate_reglrgdp`i' - lrgdp) if newt`i'>=4*wstart+1 & newt`i'<4*wend+2 //modif  /*& recession==0*/
by episode`i': egen extrapolate_N`i' = sum(extrapolate_simpdiff`i'!=.) if episode`i'!=""

by episode`i': gen extrapolate_simpdiff_trend`i' = -1*(extrapolate_reglrgdp_trend`i' - lrgdp) if newt`i'>=4*wstart+1 & newt`i'<4*wend+2 //modif  /*& recession==0*/
by episode`i': egen extrapolate_N_trend`i' = sum(extrapolate_simpdiff_trend`i'!=.) if episode`i'!=""

by episode`i': gen extrapolate_simpdiffgdp`i' = -1*(extrapolate_reglngdp`i' - lngdp) if newt`i'>=4*wstart+1 & newt`i'<4*wend+2 //modif  /*& recession==0*/
by episode`i': egen extrapolate_Ngdp`i' = sum(extrapolate_simpdiffgdp`i'!=.) if episode`i'!=""
by episode`i': gen extrapolate_simpdiffemp`i' = -1*(extrapolate_reglnemp`i' - lnemp) if newt`i'>=4*wstart+1 & newt`i'<4*wend+2 //modif  /*& recession==0*/
by episode`i': egen extrapolate_Nemp`i' = sum(extrapolate_simpdiffemp`i'!=.) if episode`i'!=""
by episode`i': gen extrapolate_simpdiffprod`i' = -1*(extrapolate_reglnprod`i' - lnprod) if newt`i'>=4*wstart+1 & newt`i'<4*wend+2 //modif  /*& recession==0*/
by episode`i': egen extrapolate_Nprod`i' = sum(extrapolate_simpdiffprod`i'!=.) if episode`i'!=""


by episode`i': gen extrapolate_simpdiffwap`i' = -1*(extrapolate_reglnwap`i' - lnwap) if newt`i'>=4*wstart+1 & newt`i'<4*wend+2 //modif  /*& recession==0*/
by episode`i': egen extrapolate_Nwap`i' = sum(extrapolate_simpdiffwap`i'!=.) if episode`i'!=""
by episode`i': gen extrapolate_simpdifflfp`i' = -1*(extrapolate_reglnlfp`i' - lnlfp) if newt`i'>=4*wstart+1 & newt`i'<4*wend+2 //modif  /*& recession==0*/
by episode`i': egen extrapolate_Nlfp`i' = sum(extrapolate_simpdifflfp`i'!=.) if episode`i'!=""
by episode`i': gen extrapolate_simpdiffemprate`i' = -1*(extrapolate_reglnemprate`i' - lnemprate) if newt`i'>=4*wstart+1 & newt`i'<4*wend+2 //modif  /*& recession==0*/
by episode`i': egen extrapolate_Nemprate`i' = sum(extrapolate_simpdiffemprate`i'!=.) if episode`i'!=""



//NEW
	//Difference between estimated trend corrected by quadratic coefficient and actual
by episode`i': gen extrapolate_tempdiffA`i' = -1*(extrapolate_reglrgdp`i' - lrgdp - adjustedgap2`i') if newt`i'>=4*wstart+1 & newt`i'<4*wend+2 //modif   /*& recession==0*/
by episode`i': egen extrapolate_mndiffA`i' = min(extrapolate_tempdiffA`i') if extrapolate_N`i'>=3

by episode`i': gen extrapolate_tempdiffA_trend`i' = -1*(extrapolate_reglrgdp_trend`i' - lrgdp - adjustedgap2`i') if newt`i'>=4*wstart+1 & newt`i'<4*wend+2 //modif   /*& recession==0*/
by episode`i': egen extrapolate_mndiffA_trend`i' = min(extrapolate_tempdiffA_trend`i') if extrapolate_N`i'>=3

by episode`i': gen extrapolate_tempdiffgdpA`i' = -1*(extrapolate_reglngdp`i' - lngdp - adjustedgapgdp2`i') if newt`i'>=4*wstart+1 & newt`i'<4*wend+2 //modif   /*& recession==0*/
by episode`i': egen extrapolate_mndiffgdpA`i' = min(extrapolate_tempdiffgdpA`i') if extrapolate_Ngdp`i'>=3
by episode`i': gen extrapolate_tempdiffempA`i' = -1*(extrapolate_reglnemp`i' - lnemp - adjustedgapemp2`i') if newt`i'>=4*wstart+1 & newt`i'<4*wend+2 //modif   /*& recession==0*/
by episode`i': egen extrapolate_mndiffempA`i' = min(extrapolate_tempdiffempA`i') if extrapolate_Nemp`i'>=3
by episode`i': gen extrapolate_tempdiffprodA`i' = -1*(extrapolate_reglnprod`i' - lnprod - adjustedgapprod2`i') if newt`i'>=4*wstart+1 & newt`i'<4*wend+2 //modif   /*& recession==0*/
by episode`i': egen extrapolate_mndiffprodA`i' = min(extrapolate_tempdiffprodA`i') if extrapolate_Nprod`i'>=3


by episode`i': gen extrapolate_tempdiffwapA`i' = -1*(extrapolate_reglnwap`i' - lnwap - adjustedgapwap2`i') if newt`i'>=4*wstart+1 & newt`i'<4*wend+2 //modif  /*& recession==0*/
by episode`i': egen extrapolate_lndiffwapA`i' = min(extrapolate_tempdiffwapA`i'!=.) if episode`i'!=""
by episode`i': gen extrapolate_tempdifflfpA`i' = -1*(extrapolate_reglnlfp`i' - lnlfp - adjustedgaplfp2`i') if newt`i'>=4*wstart+1 & newt`i'<4*wend+2 //modif  /*& recession==0*/
by episode`i': egen extrapolate_mndifflfpA`i' = min(extrapolate_tempdifflfpA`i'!=.) if episode`i'!=""
by episode`i': gen extrapolate_tempdiffemprateA`i' = -1*(extrapolate_reglnemprate`i' - lnemprate - adjustedgapemprate2`i') if newt`i'>=4*wstart+1 & newt`i'<4*wend+2 //modif  /*& recession==0*/
by episode`i': egen extrapolate_mndiffemprateA`i' = min(extrapolate_tempdiffemprateA`i'!=.) if episode`i'!=""




********************************************************************************
// 9. Initial and Max Output drop up to 3 years after trough
********************************************************************************

//Initial drop
by episode`i': gen dlrgdp_peak_trough`i' = (lrgdp - lrgdp[_n-rest`i'])*(-1) if  newt`i'==1 //1 is the trough; new to calculate as function of the fall
by episode`i': egen lrgdp_peak_trough`i' = min(dlrgdp_peak_trough`i')  //new to calculate as function of the fall

by episode`i': gen dlngdp_peak_trough`i' = (lngdp - lngdp[_n-rest`i'])*(-1) if  newt`i'==1 //1 is the trough; new to calculate as function of the fall
by episode`i': egen lngdp_peak_trough`i' = min(dlngdp_peak_trough`i')  //new to calculate as function of the fall
by episode`i': gen dlnemp_peak_trough`i' = (lnemp - lnemp[_n-rest`i'])*(-1) if  newt`i'==1 //1 is the trough; new to calculate as function of the fall
by episode`i': egen lnemp_peak_trough`i' = min(dlnemp_peak_trough`i')  //new to calculate as function of the fall
by episode`i': gen dlnprod_peak_trough`i' = (lnprod - lnprod[_n-rest`i'])*(-1) if  newt`i'==1 //1 is the trough; new to calculate as function of the fall
by episode`i': egen lnprod_peak_trough`i' = min(dlnprod_peak_trough`i')  //new to calculate as function of the fall


by episode`i': gen dlnwap_peak_trough`i' = (lnwap - lnwap[_n-rest`i'])*(-1) if  newt`i'==1 //1 is the trough; new to calculate as function of the fall
by episode`i': egen lnwap_peak_trough`i' = min(dlnwap_peak_trough`i')  //new to calculate as function of the fall
by episode`i': gen dlnlfp_peak_trough`i' = (lnlfp - lnlfp[_n-rest`i'])*(-1) if  newt`i'==1 //1 is the trough; new to calculate as function of the fall
by episode`i': egen lnlfp_peak_trough`i' = min(dlnlfp_peak_trough`i')  //new to calculate as function of the fall
by episode`i': gen dlnemprate_peak_trough`i' = (lnemprate - lnemprate[_n-rest`i'])*(-1) if  newt`i'==1 //1 is the trough; new to calculate as function of the fall
by episode`i': egen lnemprate_peak_trough`i' = min(dlnemprate_peak_trough`i')  //new to calculate as function of the fall



//Max Output drop
by episode`i': gen outputdropA`i' = extrapolate_reglngdp`i' - lngdp - adjustedgapgdp2`i' if newt`i'>=1 & newt`i'<14   /*& recession==0*/
by episode`i': gen diffoutputdropA`i' = outputdropA`i' - outputdropA`i'[_n-1] if newt`i'>=2 & newt`i'<14  /*& recession==0*/
by episode`i': egen maxoutputdropA`i' = max(outputdropA`i') if newt`i'>=1 & newt`i'<14   /*& recession==0*/
by episode`i': gen maxdiffoutputdropA`i' = outputdropA`i' - maxoutputdropA`i' if newt`i'>=1 & newt`i'<14  /*& recession==0*/

//Number quarters after trough the max output drop is reached, if = 12 (3years) then output gap still increasing when we start to compute gaps
by episode`i': gen datemaxoutputdropA`i' = 1 if maxdiffoutputdropA`i'== 0
by episode`i': gen nquartersmaxoutputdropA`i' = newt`i'-1 if datemaxoutputdropA`i' == 1 

//MaxGDPdrop is max between actual output drop and maxoutputdrop (which can be lower than actual output drop if extrapolated trend is below peak)
by episode`i': gen maxGDPdropA`i' = max(maxoutputdropA`i', lngdp_peak_trough`i') if newt`i'>=1 & newt`i'<14  /*& recession==0*/


//Max Output drop
by episode`i': gen outputdropA_trend`i' = extrapolate_reglrgdp_trend`i' - lrgdp - adjustedgap2`i' if newt`i'>=1 & newt`i'<14   /*& recession==0*/
by episode`i': gen diffoutputdropA_trend`i' = outputdropA_trend`i' - outputdropA_trend`i'[_n-1] if newt`i'>=2 & newt`i'<14  /*& recession==0*/
by episode`i': egen maxoutputdropA_trend`i' = max(outputdropA_trend`i') if newt`i'>=1 & newt`i'<14   /*& recession==0*/
by episode`i': gen maxdiffoutputdropA_trend`i' = outputdropA_trend`i' - maxoutputdropA_trend`i' if newt`i'>=1 & newt`i'<14  /*& recession==0*/

//Number quarters after trough the max output drop is reached, if = 12 (3years) then output gap still increasing when we start to compute gaps
by episode`i': gen datemaxoutputdropA_trend`i' = 1 if maxdiffoutputdropA_trend`i'== 0
by episode`i': gen nquartersmaxoutputdropA_trend`i' = newt`i'-1 if datemaxoutputdropA_trend`i' == 1 

//MaxGDPdrop is max between actual output drop and maxoutputdrop (which can be lower than actual output drop if extrapolated trend is below peak)
by episode`i': gen maxGDPdropA_trend`i' = max(maxoutputdropA_trend`i', lrgdp_peak_trough`i') if newt`i'>=1 & newt`i'<14  /*& recession==0*/


/*
//Max employment drop
by episode`i': gen employmentdropA`i' = extrapolate_reglnemp`i' - lnemp - adjustedgapemp2`i' if newt`i'>=1 & newt`i'<14   /*& recession==0*/
by episode`i': gen diffemploymentdropA`i' = employmentdropA`i' - employmentdropA`i'[_n-1] if newt`i'>=2 & newt`i'<14  /*& recession==0*/
by episode`i': egen maxemploymentdropA`i' = max(employmentdropA`i') if newt`i'>=1 & newt`i'<14   /*& recession==0*/
by episode`i': gen maxdiffemploymentdropA`i' = employmentdropA`i' - maxemploymentdropA`i' if newt`i'>=1 & newt`i'<14  /*& recession==0*/

//Number quarters after trough the max employment drop is reached, if = 12 (3years) then employment gap still increasing when we start to compute gaps
by episode`i': gen datemaxemploymentdropA`i' = 1 if maxdiffemploymentdropA`i'== 0
by episode`i': gen nquartersmaxemploymentdropA`i' = newt`i'-1 if datemaxemploymentdropA`i' == 1 

//Maxempdrop is max between actual employment drop and maxemploymentdrop (which can be lower than actual employment drop if extrapolated trend is below peak)
by episode`i': gen maxempdropA`i' = max(maxemploymentdropA`i', lnemp_peak_trough`i') if newt`i'>=1 & newt`i'<14  /*& recession==0*/


//Max productivity drop
by episode`i': gen productivitydropA`i' = extrapolate_reglnprod`i' - lnprod - adjustedgapprod2`i' if newt`i'>=1 & newt`i'<14   /*& recession==0*/
by episode`i': gen diffproductivitydropA`i' = productivitydropA`i' - productivitydropA`i'[_n-1] if newt`i'>=2 & newt`i'<14  /*& recession==0*/
by episode`i': egen maxproductivitydropA`i' = max(productivitydropA`i') if newt`i'>=1 & newt`i'<14   /*& recession==0*/
by episode`i': gen maxdiffproductivitydropA`i' = productivitydropA`i' - maxproductivitydropA`i' if newt`i'>=1 & newt`i'<14  /*& recession==0*/

//Number quarters after trough the max productivity drop is reached, if = 12 (3years) then productivity gap still increasing when we start to compute gaps
by episode`i': gen datemaxproductivitydropA`i' = 1 if maxdiffproductivitydropA`i'== 0
by episode`i': gen nquartersmaxproductivitydropA`i' = newt`i'-1 if datemaxproductivitydropA`i' == 1 

//Maxproddrop is max between actual productivity drop and maxproductivitydrop (which can be lower than actual productivity drop if extrapolated trend is below peak)
by episode`i': gen maxproddropA`i' = max(maxproductivitydropA`i', lnprod_peak_trough`i') if newt`i'>=1 & newt`i'<14  /*& recession==0*/


//Max laborforceparticipation drop
by episode`i': gen laborforceparticipationdropA`i' = extrapolate_reglnlfp`i' - lnlfp - adjustedgaplfp2`i' if newt`i'>=1 & newt`i'<14   /*& recession==0*/
by episode`i': gen difflaborforceparticipationdropA`i' = laborforceparticipationdropA`i' - laborforceparticipationdropA`i'[_n-1] if newt`i'>=2 & newt`i'<14  /*& recession==0*/
by episode`i': egen maxlaborforceparticipationdropA`i' = max(laborforceparticipationdropA`i') if newt`i'>=1 & newt`i'<14   /*& recession==0*/
by episode`i': gen maxdifflaborforceparticipationdropA`i' = laborforceparticipationdropA`i' - maxlaborforceparticipationdropA`i' if newt`i'>=1 & newt`i'<14  /*& recession==0*/

//Number quarters after trough the max laborforceparticipation drop is reached, if = 12 (3years) then laborforceparticipation gap still increasing when we start to compute gaps
by episode`i': gen datemaxlaborforceparticipationdropA`i' = 1 if maxdifflaborforceparticipationdropA`i'== 0
by episode`i': gen nquartersmaxlaborforceparticipationdropA`i' = newt`i'-1 if datemaxlaborforceparticipationdropA`i' == 1 

//Maxlfpdrop is max between actual laborforceparticipation drop and maxlaborforceparticipationdrop (which can be lower than actual laborforceparticipation drop if extrapolated trend is below peak)
by episode`i': gen maxlfpdropA`i' = max(maxlaborforceparticipationdropA`i', lnlfp_peak_trough`i') if newt`i'>=1 & newt`i'<14  /*& recession==0*/


//Max workingagepopulation drop
by episode`i': gen workingagepopulationdropA`i' = extrapolate_reglnwap`i' - lnwap - adjustedgapwap2`i' if newt`i'>=1 & newt`i'<14   /*& recession==0*/
by episode`i': gen diffworkingagepopulationdropA`i' = workingagepopulationdropA`i' - workingagepopulationdropA`i'[_n-1] if newt`i'>=2 & newt`i'<14  /*& recession==0*/
by episode`i': egen maxworkingagepopulationdropA`i' = max(workingagepopulationdropA`i') if newt`i'>=1 & newt`i'<14   /*& recession==0*/
by episode`i': gen maxdiffworkingagepopulationdropA`i' = workingagepopulationdropA`i' - maxworkingagepopulationdropA`i' if newt`i'>=1 & newt`i'<14  /*& recession==0*/

//Number quarters after trough the max workingagepopulation drop is reached, if = 12 (3years) then workingagepopulation gap still increasing when we start to compute gaps
by episode`i': gen datemaxworkingagepopulationdropA`i' = 1 if maxdiffworkingagepopulationdropA`i'== 0
by episode`i': gen nquartersmaxworkingagepopulationdropA`i' = newt`i'-1 if datemaxworkingagepopulationdropA`i' == 1 

//Maxwapdrop is max between actual workingagepopulation drop and maxworkingagepopulationdrop (which can be lower than actual workingagepopulation drop if extrapolated trend is below peak)
by episode`i': gen maxwapdropA`i' = max(maxworkingagepopulationdropA`i', lnwap_peak_trough`i') if newt`i'>=1 & newt`i'<14  /*& recession==0*/


//Max employmentrate drop
by episode`i': gen employmentratedropA`i' = extrapolate_reglnemprate`i' - lnemprate - adjustedgapemprate2`i' if newt`i'>=1 & newt`i'<14   /*& recession==0*/
by episode`i': gen diffemploymentratedropA`i' = employmentratedropA`i' - employmentratedropA`i'[_n-1] if newt`i'>=2 & newt`i'<14  /*& recession==0*/
by episode`i': egen maxemploymentratedropA`i' = max(employmentratedropA`i') if newt`i'>=1 & newt`i'<14   /*& recession==0*/
by episode`i': gen maxdiffemploymentratedropA`i' = employmentratedropA`i' - maxemploymentratedropA`i' if newt`i'>=1 & newt`i'<14  /*& recession==0*/

//Number quarters after trough the max employmentrate drop is reached, if = 12 (3years) then employmentrate gap still increasing when we start to compute gaps
by episode`i': gen datemaxemploymentratedropA`i' = 1 if maxdiffemploymentratedropA`i'== 0
by episode`i': gen nquartersmaxemploymentratedropA`i' = newt`i'-1 if datemaxemploymentratedropA`i' == 1 

//Maxempratedrop is max between actual employmentrate drop and maxemploymentratedrop (which can be lower than actual employmentrate drop if extrapolated trend is below peak)
by episode`i': gen maxempratedropA`i' = max(maxemploymentratedropA`i', lnemprate_peak_trough`i') if newt`i'>=1 & newt`i'<14  /*& recession==0*/
*/



********************************************************************************
// 10. Gaps at t1+12; t1+27; Difference between extrapolation and actual GDP at peak
********************************************************************************

by episode`i': gen lrgdpgap12A`i' = extrapolate_tempdiffA`i' if newt`i'==13
by episode`i': gen lrgdpgap27A`i' = extrapolate_tempdiffA`i' if newt`i'==29
by episode`i': gen lrgdpgap20A`i' = extrapolate_tempdiffA`i' if newt`i'==21

by episode`i': gen lrgdpgap12A_trend`i' = extrapolate_tempdiffA_trend`i' if newt`i'==13
by episode`i': gen lrgdpgap27A_trend`i' = extrapolate_tempdiffA_trend`i' if newt`i'==29
by episode`i': gen lrgdpgap20A_trend`i' = extrapolate_tempdiffA_trend`i' if newt`i'==21

by episode`i': gen lngdpgap12A`i' = extrapolate_tempdiffgdpA`i' if newt`i'==13
by episode`i': gen lngdpgap27A`i' = extrapolate_tempdiffgdpA`i' if newt`i'==29
by episode`i': gen lngdpgap20A`i' = extrapolate_tempdiffgdpA`i' if newt`i'==21

by episode`i': gen lnempgap12A`i' = extrapolate_tempdiffempA`i' if newt`i'==13
by episode`i': gen lnempgap27A`i' = extrapolate_tempdiffempA`i' if newt`i'==29
by episode`i': gen lnempgap20A`i' = extrapolate_tempdiffempA`i' if newt`i'==21

by episode`i': gen lnprodgap12A`i' = extrapolate_tempdiffprodA`i' if newt`i'==13
by episode`i': gen lnprodgap27A`i' = extrapolate_tempdiffprodA`i' if newt`i'==29
by episode`i': gen lnprodgap20A`i' = extrapolate_tempdiffprodA`i' if newt`i'==21


by episode`i': gen lnwapgap12A`i' = extrapolate_tempdiffwapA`i' if newt`i'==13
by episode`i': gen lnwapgap27A`i' = extrapolate_tempdiffwapA`i' if newt`i'==29
by episode`i': gen lnwapgap20A`i' = extrapolate_tempdiffwapA`i' if newt`i'==21

by episode`i': gen lnlfpgap12A`i' = extrapolate_tempdifflfpA`i' if newt`i'==13
by episode`i': gen lnlfpgap27A`i' = extrapolate_tempdifflfpA`i' if newt`i'==29
by episode`i': gen lnlfpgap20A`i' = extrapolate_tempdifflfpA`i' if newt`i'==21

by episode`i': gen lnemprategap12A`i' = extrapolate_tempdiffemprateA`i' if newt`i'==13
by episode`i': gen lnemprategap27A`i' = extrapolate_tempdiffemprateA`i' if newt`i'==29
by episode`i': gen lnemprategap20A`i' = extrapolate_tempdiffemprateA`i' if newt`i'==21
********************************************************************************


by episode`i': gen diffextragdppeak`i' = extrapolate_reglngdpA`i' - lngdp if id`i'==1+(8+2*window)+cb_adj_start`i'
by episode`i': gen diffextragdppeak_trend`i' = extrapolate_reglrgdpA_trend`i' - lrgdp if id`i'==1+(8+2*window)

by episode`i': gen diffextraemppeak`i' = extrapolate_reglnempA`i' - lnemp if id`i'==1+(8+2*window)+cb_adj_start`i'
by episode`i': gen diffextraprodpeak`i' = extrapolate_reglnprodA`i' - lnprod if id`i'==1+(8+2*window)+cb_adj_start`i'

by episode`i': gen diffextrawappeak`i' = extrapolate_reglnwapA`i' - lnwap if id`i'==1+(8+2*window)+cb_adj_start`i'
by episode`i': gen diffextralfppeak`i' = extrapolate_reglnlfpA`i' - lnlfp if id`i'==1+(8+2*window)+cb_adj_start`i'
by episode`i': gen diffextraempratepeak`i' = extrapolate_reglnemprateA`i' - lnemprate if id`i'==1+(8+2*window)+cb_adj_start`i'



********************************************************************************
// 11. Analysis of Gaps
********************************************************************************

gen trendAvg`i' = .
gen trendAvg_cons`i' =.
gen trendAvg_Rcons`i' =.
gen trendAvg_consp`i' = .
gen trendAvg_beta`i' =.
gen trendAvg_betap`i' =.
gen trendAvg_mndiff`i'=.

gen trendAvggdp`i' = .
gen trendAvggdp_cons`i' =.
gen trendAvggdp_Rcons`i' =.
gen trendAvggdp_consp`i' = .
gen trendAvggdp_beta`i' =.
gen trendAvggdp_betap`i' =.
gen trendAvggdp_mndiff`i'=.

gen trendAvgemp`i' = .
gen trendAvgemp_cons`i' =.
gen trendAvgemp_Rcons`i' =.
gen trendAvgemp_consp`i' = .
gen trendAvgemp_beta`i' =.
gen trendAvgemp_betap`i' =.
gen trendAvgemp_mndiff`i'=.

gen trendAvgprod`i' = .
gen trendAvgprod_cons`i' =.
gen trendAvgprod_Rcons`i' =.
gen trendAvgprod_consp`i' = .
gen trendAvgprod_beta`i' =.
gen trendAvgprod_betap`i' =.
gen trendAvgprod_mndiff`i'=.

/*
gen trendAvgwap`i' = .
gen trendAvgwap_cons`i' =.
gen trendAvgwap_Rcons`i' =.
gen trendAvgwap_consp`i' = .
gen trendAvgwap_beta`i' =.
gen trendAvgwap_betap`i' =.
gen trendAvgwap_mndiff`i'=.

gen trendAvglfp`i' = .
gen trendAvglfp_cons`i' =.
gen trendAvglfp_Rcons`i' =.
gen trendAvglfp_consp`i' = .
gen trendAvglfp_beta`i' =.
gen trendAvglfp_betap`i' =.

gen trendAvgemprate_mndiff`i'=.
gen trendAvgemprate`i' = .
gen trendAvgemprate_cons`i' =.
gen trendAvgemprate_Rcons`i' =.
gen trendAvgemprate_consp`i' = .
gen trendAvgemprate_beta`i' =.
gen trendAvgemprate_betap`i' =.
gen trendAvgemprate_mndiff`i'=.
*/

gen trendA`i' = .
gen trendA_cons`i' =.
gen trendA_consp`i' = .
gen trendA_beta`i' =.
gen trendA_betap`i' =.
gen trendA_mndiff`i' = .

gen trendgdpA`i' = .
gen trendgdpA_cons`i' =.
gen trendgdpA_consp`i' = .
gen trendgdpA_beta`i' =.
gen trendgdpA_betap`i' =.
gen trendgdpA_mndiff`i' = .

gen trendempA`i' = .
gen trendempA_cons`i' =.
gen trendempA_consp`i' = .
gen trendempA_beta`i' =.
gen trendempA_betap`i' =.
gen trendempA_mndiff`i' = .

gen trendprodA`i' = .
gen trendprodA_cons`i' =.
gen trendprodA_consp`i' = .
gen trendprodA_beta`i' =.
gen trendprodA_betap`i' =.
gen trendprodA_mndiff`i' = .

/*
gen trendwapA`i' = .
gen trendwapA_cons`i' =.
gen trendwapA_consp`i' = .
gen trendwapA_beta`i' =.
gen trendwapA_betap`i' =.
gen trendwapA_mndiff`i' = .

gen trendlfpA`i' = .
gen trendlfpA_cons`i' =.
gen trendlfpA_consp`i' = .
gen trendlfpA_beta`i' =.
gen trendlfpA_betap`i' =.
gen trendlfpA_mndiff`i' = .

gen trendemprateA`i' = .
gen trendemprateA_cons`i' =.
gen trendemprateA_consp`i' = .
gen trendemprateA_beta`i' =.
gen trendemprateA_betap`i' =.
gen trendemprateA_mndiff`i' = .
*/

levelsof episode`i' if extrapolate_N`i'>=3, local(episodes)
levelsof ifscode, local(codes)

foreach c in `codes' {
sum extrapolate_tempdiffA`i' if ifscode==`c'
gen regN`i' = r(N)
if regN`i'>2 {
reg extrapolate_tempdiffA`i' if ifscode==`c'
test _b[_cons]=0
gen pL_cons = r(p)
replace trendAvg_cons`i'  = _b[_cons] if ifscode==`c'
replace trendAvg_consp`i' = pL_cons   if ifscode==`c'	
replace trendAvg_Rcons`i' = trendAvg_cons`i'/ lrgdp_peak_trough`i' if ifscode==`c' //new to calculate as function of the fall

drop pL_cons //pL_beta
}
else {
replace trendAvg_cons`i' = . if ifscode==`c'
replace trendAvg_consp`i' = . if ifscode==`c'
}
drop regN`i'

sum extrapolate_tempdiffA`i' if ifscode==`c'
gen regN`i' = r(N)
if regN`i'>2 {
reg extrapolate_tempdiffA`i' newt`i' if ifscode==`c'
test _b[_cons]=0
gen pA_cons = r(p)
test _b[newt`i']=0
gen pA_beta = r(p)

	// trendA to see if output gap is increasing over time or not
replace trendA`i' = 2 if ifscode==`c' & pA_beta<0.01 & _b[newt`i']>0 				// Increasing and significant
replace trendA`i' = 1 if ifscode==`c' & pA_beta>0.01 & _b[_cons]>0					// Positive and non significant
replace trendA`i' = 3 if ifscode==`c' & pA_beta<0.01 & _b[_cons]>0 & _b[newt`i']<0	// Positive decrasing and significant
replace trendA`i' = 4 if ifscode==`c' & pA_beta<0.01 & _b[_cons]<0 & _b[newt`i']>0	// Negative increasing and significant
replace trendA`i' = 5 if ifscode==`c' & pA_beta>0.01 & _b[_cons]<0					// Negative and non significant
replace trendA`i' = 6 if ifscode==`c' & pA_beta<0.01 & _b[_cons]<0 & _b[newt`i']<0	// Negative decrasing and significant

replace trendA_cons`i'  = _b[_cons] if ifscode==`c'
replace trendA_consp`i' = pA_cons   if ifscode==`c'
replace trendA_beta`i'  = _b[newt`i'] if ifscode==`c'
replace trendA_betap`i' = pA_beta   if ifscode==`c'
replace trendA_mndiff`i'= extrapolate_mndiffA`i' if ifscode==`c'
drop pA_cons pA_beta
}
else {
replace trendA`i' = . if ifscode==`c'
replace trendA_cons`i' = . if ifscode==`c'
replace trendA_consp`i' = . if ifscode==`c'
replace trendA_beta`i' = . if ifscode==`c'
replace trendA_betap`i' = . if ifscode==`c'
replace trendA_mndiff`i'= . if ifscode==`c'
}
drop regN`i'
}


foreach c in `codes' {
sum extrapolate_tempdiffgdpA`i' if ifscode==`c'
gen regNgdp`i' = r(N)
if regNgdp`i'>2 {
reg extrapolate_tempdiffgdpA`i' if ifscode==`c'
test _b[_cons]=0
gen pLgdp_cons = r(p)
replace trendAvggdp_cons`i'  = _b[_cons] if ifscode==`c'
replace trendAvggdp_consp`i' = pLgdp_cons   if ifscode==`c'
replace trendAvggdp_Rcons`i' = trendAvggdp_cons`i'/ lngdp_peak_trough`i' if ifscode==`c' //new to calculate as function of the fall
drop pLgdp_cons //pL_beta
}
else {
replace trendAvggdp_cons`i' = . if ifscode==`c'
replace trendAvggdp_consp`i' = . if ifscode==`c'
}
drop regNgdp`i'

sum extrapolate_tempdiffgdpA`i' if ifscode==`c'
gen regNgdp`i' = r(N)
if regNgdp`i'>2 {
reg extrapolate_tempdiffgdpA`i' newt`i' if ifscode==`c'
test _b[_cons]=0
gen pAgdp_cons = r(p)
test _b[newt`i']=0
gen pAgdp_beta = r(p)
replace trendgdpA`i' = 2 if ifscode==`c' & pAgdp_beta<0.01 & _b[newt`i']>0
replace trendgdpA`i' = 1 if ifscode==`c' & pAgdp_beta>0.01 & _b[_cons]>0
replace trendgdpA`i' = 3 if ifscode==`c' & pAgdp_beta<0.01 & _b[_cons]>0 & _b[newt`i']<0
replace trendgdpA`i' = 4 if ifscode==`c' & pAgdp_beta<0.01 & _b[_cons]<0 & _b[newt`i']>0
replace trendgdpA`i' = 5 if ifscode==`c' & pAgdp_beta>0.01 & _b[_cons]<0
replace trendgdpA`i' = 6 if ifscode==`c' & pAgdp_beta<0.01 & _b[_cons]<0 & _b[newt`i']<0
replace trendgdpA_cons`i'  = _b[_cons] if ifscode==`c'
replace trendgdpA_consp`i' = pAgdp_cons   if ifscode==`c'
replace trendgdpA_beta`i'  = _b[newt`i'] if ifscode==`c'
replace trendgdpA_betap`i' = pAgdp_beta   if ifscode==`c'
replace trendgdpA_mndiff`i'= extrapolate_mndiffgdpA`i' if ifscode==`c'
drop pAgdp_cons pAgdp_beta
}
else {
replace trendgdpA`i' = . if ifscode==`c'
replace trendgdpA_cons`i' = . if ifscode==`c'
replace trendgdpA_consp`i' = . if ifscode==`c'
replace trendgdpA_beta`i' = . if ifscode==`c'
replace trendgdpA_betap`i' = . if ifscode==`c'
replace trendgdpA_mndiff`i'= . if ifscode==`c'
}
drop regNgdp`i'
}

foreach c in `codes' {
sum extrapolate_tempdiffempA`i' if ifscode==`c'
gen regNemp`i' = r(N)
if regNemp`i'>2 {
reg extrapolate_tempdiffempA`i' if ifscode==`c'
test _b[_cons]=0
gen pLemp_cons = r(p)
replace trendAvgemp_cons`i'  = _b[_cons] if ifscode==`c'
replace trendAvgemp_consp`i' = pLemp_cons   if ifscode==`c'
replace trendAvgemp_Rcons`i' = trendAvgemp_cons`i'/ lnemp_peak_trough`i' if ifscode==`c' //new to calculate as function of the fall
drop pLemp_cons //pL_beta
}
else {
replace trendAvgemp_cons`i' = . if ifscode==`c'
replace trendAvgemp_consp`i' = . if ifscode==`c'
}
drop regNemp`i'

sum extrapolate_tempdiffempA`i' if ifscode==`c'
gen regNemp`i' = r(N)
if regNemp`i'>2 {
reg extrapolate_tempdiffempA`i' newt`i' if ifscode==`c'
test _b[_cons]=0
gen pAemp_cons = r(p)
test _b[newt`i']=0
gen pAemp_beta = r(p)
replace trendempA`i' = 2 if ifscode==`c' & pAemp_beta<0.01 & _b[newt`i']>0
replace trendempA`i' = 1 if ifscode==`c' & pAemp_beta>0.01 & _b[_cons]>0
replace trendempA`i' = 3 if ifscode==`c' & pAemp_beta<0.01 & _b[_cons]>0 & _b[newt`i']<0
replace trendempA`i' = 4 if ifscode==`c' & pAemp_beta<0.01 & _b[_cons]<0 & _b[newt`i']>0
replace trendempA`i' = 5 if ifscode==`c' & pAemp_beta>0.01 & _b[_cons]<0
replace trendempA`i' = 6 if ifscode==`c' & pAemp_beta<0.01 & _b[_cons]<0 & _b[newt`i']<0
replace trendempA_cons`i'  = _b[_cons] if ifscode==`c'
replace trendempA_consp`i' = pAemp_cons   if ifscode==`c'
replace trendempA_beta`i'  = _b[newt`i'] if ifscode==`c'
replace trendempA_betap`i' = pAemp_beta   if ifscode==`c'
replace trendempA_mndiff`i'= extrapolate_mndiffempA`i' if ifscode==`c'
drop pAemp_cons pAemp_beta
}
else {
replace trendempA`i' = . if ifscode==`c'
replace trendempA_cons`i' = . if ifscode==`c'
replace trendempA_consp`i' = . if ifscode==`c'
replace trendempA_beta`i' = . if ifscode==`c'
replace trendempA_betap`i' = . if ifscode==`c'
replace trendempA_mndiff`i'= . if ifscode==`c'
}
drop regNemp`i'
}

foreach c in `codes' {
sum extrapolate_tempdiffprodA`i' if ifscode==`c'
gen regNprod`i' = r(N)
if regNprod`i'>2 {
reg extrapolate_tempdiffprodA`i' if ifscode==`c'
test _b[_cons]=0
gen pLprod_cons = r(p)
replace trendAvgprod_cons`i'  = _b[_cons] if ifscode==`c'
replace trendAvgprod_consp`i' = pLprod_cons   if ifscode==`c'
replace trendAvgprod_Rcons`i' = trendAvgprod_cons`i'/ lnprod_peak_trough`i' if ifscode==`c' //new to calculate as function of the fall
drop pLprod_cons //pL_beta
}
else {
replace trendAvgprod_cons`i' = . if ifscode==`c'
replace trendAvgprod_consp`i' = . if ifscode==`c'
}
drop regNprod`i'

sum extrapolate_tempdiffprodA`i' if ifscode==`c'
gen regNprod`i' = r(N)
if regNprod`i'>2 {
reg extrapolate_tempdiffprodA`i' newt`i' if ifscode==`c'
test _b[_cons]=0
gen pAprod_cons = r(p)
test _b[newt`i']=0
gen pAprod_beta = r(p)
replace trendprodA`i' = 2 if ifscode==`c' & pAprod_beta<0.01 & _b[newt`i']>0
replace trendprodA`i' = 1 if ifscode==`c' & pAprod_beta>0.01 & _b[_cons]>0
replace trendprodA`i' = 3 if ifscode==`c' & pAprod_beta<0.01 & _b[_cons]>0 & _b[newt`i']<0
replace trendprodA`i' = 4 if ifscode==`c' & pAprod_beta<0.01 & _b[_cons]<0 & _b[newt`i']>0
replace trendprodA`i' = 5 if ifscode==`c' & pAprod_beta>0.01 & _b[_cons]<0
replace trendprodA`i' = 6 if ifscode==`c' & pAprod_beta<0.01 & _b[_cons]<0 & _b[newt`i']<0
replace trendprodA_cons`i'  = _b[_cons] if ifscode==`c'
replace trendprodA_consp`i' = pAprod_cons   if ifscode==`c'
replace trendprodA_beta`i'  = _b[newt`i'] if ifscode==`c'
replace trendprodA_betap`i' = pAprod_beta   if ifscode==`c'
replace trendprodA_mndiff`i'= extrapolate_mndiffprodA`i' if ifscode==`c'
drop pAprod_cons pAprod_beta
}
else {
replace trendprodA`i' = . if ifscode==`c'
replace trendprodA_cons`i' = . if ifscode==`c'
replace trendprodA_consp`i' = . if ifscode==`c'
replace trendprodA_beta`i' = . if ifscode==`c'
replace trendprodA_betap`i' = . if ifscode==`c'
replace trendprodA_mndiff`i'= . if ifscode==`c'
}
drop regNprod`i'
}



//NEW
/*
foreach c in `codes' {
sum extrapolate_tempdiffwapA`i' if ifscode==`c'
gen regNwap`i' = r(N)
if regNwap`i'>2 {
reg extrapolate_tempdiffwapA`i' if ifscode==`c'
test _b[_cons]=0
gen pLwap_cons = r(p)
replace trendAvgwap_cons`i'  = _b[_cons] if ifscode==`c'
replace trendAvgwap_consp`i' = pLwap_cons   if ifscode==`c'
replace trendAvgwap_Rcons`i' = trendAvgwap_cons`i'/ lnwap_peak_trough`i' if ifscode==`c' //new to calculate as function of the fall
drop pLwap_cons //pL_beta
}
else {
replace trendAvgwap_cons`i' = . if ifscode==`c'
replace trendAvgwap_consp`i' = . if ifscode==`c'
}
drop regNwap`i'

sum extrapolate_tempdiffwapA`i' if ifscode==`c'
gen regNwap`i' = r(N)
if regNwap`i'>2 {
reg extrapolate_tempdiffwapA`i' newt`i' if ifscode==`c'
test _b[_cons]=0
gen pAwap_cons = r(p)
test _b[newt`i']=0
gen pAwap_beta = r(p)
replace trendwapA`i' = 2 if ifscode==`c' & pAwap_beta<0.01 & _b[newt`i']>0
replace trendwapA`i' = 1 if ifscode==`c' & pAwap_beta>0.01 & _b[_cons]>0
replace trendwapA`i' = 3 if ifscode==`c' & pAwap_beta<0.01 & _b[_cons]>0 & _b[newt`i']<0
replace trendwapA`i' = 4 if ifscode==`c' & pAwap_beta<0.01 & _b[_cons]<0 & _b[newt`i']>0
replace trendwapA`i' = 5 if ifscode==`c' & pAwap_beta>0.01 & _b[_cons]<0
replace trendwapA`i' = 6 if ifscode==`c' & pAwap_beta<0.01 & _b[_cons]<0 & _b[newt`i']<0
replace trendwapA_cons`i'  = _b[_cons] if ifscode==`c'
replace trendwapA_consp`i' = pAwap_cons   if ifscode==`c'
replace trendwapA_beta`i'  = _b[newt`i'] if ifscode==`c'
replace trendwapA_betap`i' = pAwap_beta   if ifscode==`c'
replace trendwapA_mndiff`i'= extrapolate_mndiffwapA`i' if ifscode==`c'
drop pAwap_cons pAwap_beta
}
else {
replace trendwapA`i' = . if ifscode==`c'
replace trendwapA_cons`i' = . if ifscode==`c'
replace trendwapA_consp`i' = . if ifscode==`c'
replace trendwapA_beta`i' = . if ifscode==`c'
replace trendwapA_betap`i' = . if ifscode==`c'
replace trendwapA_mndiff`i'= . if ifscode==`c'
}
drop regNwap`i'
}


foreach c in `codes' {
sum extrapolate_tempdifflfpA`i' if ifscode==`c'
gen regNlfp`i' = r(N)
if regNlfp`i'>2 {
reg extrapolate_tempdifflfpA`i' if ifscode==`c'
test _b[_cons]=0
gen pLlfp_cons = r(p)
replace trendAvglfp_cons`i'  = _b[_cons] if ifscode==`c'
replace trendAvglfp_consp`i' = pLlfp_cons   if ifscode==`c'
replace trendAvglfp_Rcons`i' = trendAvglfp_cons`i'/ lnlfp_peak_trough`i' if ifscode==`c' //new to calculate as function of the fall
drop pLlfp_cons //pL_beta
}
else {
replace trendAvglfp_cons`i' = . if ifscode==`c'
replace trendAvglfp_consp`i' = . if ifscode==`c'
}
drop regNlfp`i'

sum extrapolate_tempdifflfpA`i' if ifscode==`c'
gen regNlfp`i' = r(N)
if regNlfp`i'>2 {
reg extrapolate_tempdifflfpA`i' newt`i' if ifscode==`c'
test _b[_cons]=0
gen pAlfp_cons = r(p)
test _b[newt`i']=0
gen pAlfp_beta = r(p)
replace trendlfpA`i' = 2 if ifscode==`c' & pAlfp_beta<0.01 & _b[newt`i']>0
replace trendlfpA`i' = 1 if ifscode==`c' & pAlfp_beta>0.01 & _b[_cons]>0
replace trendlfpA`i' = 3 if ifscode==`c' & pAlfp_beta<0.01 & _b[_cons]>0 & _b[newt`i']<0
replace trendlfpA`i' = 4 if ifscode==`c' & pAlfp_beta<0.01 & _b[_cons]<0 & _b[newt`i']>0
replace trendlfpA`i' = 5 if ifscode==`c' & pAlfp_beta>0.01 & _b[_cons]<0
replace trendlfpA`i' = 6 if ifscode==`c' & pAlfp_beta<0.01 & _b[_cons]<0 & _b[newt`i']<0
replace trendlfpA_cons`i'  = _b[_cons] if ifscode==`c'
replace trendlfpA_consp`i' = pAlfp_cons   if ifscode==`c'
replace trendlfpA_beta`i'  = _b[newt`i'] if ifscode==`c'
replace trendlfpA_betap`i' = pAlfp_beta   if ifscode==`c'
replace trendlfpA_mndiff`i'= extrapolate_mndifflfpA`i' if ifscode==`c'
drop pAlfp_cons pAlfp_beta
}
else {
replace trendlfpA`i' = . if ifscode==`c'
replace trendlfpA_cons`i' = . if ifscode==`c'
replace trendlfpA_consp`i' = . if ifscode==`c'
replace trendlfpA_beta`i' = . if ifscode==`c'
replace trendlfpA_betap`i' = . if ifscode==`c'
replace trendlfpA_mndiff`i'= . if ifscode==`c'
}
drop regNlfp`i'
}


foreach c in `codes' {
sum extrapolate_tempdiffemprateA`i' if ifscode==`c'
gen regNemprate`i' = r(N)
if regNemprate`i'>2 {
reg extrapolate_tempdiffemprateA`i' if ifscode==`c'
test _b[_cons]=0
gen pLemprate_cons = r(p)
replace trendAvgemprate_cons`i'  = _b[_cons] if ifscode==`c'
replace trendAvgemprate_consp`i' = pLemprate_cons   if ifscode==`c'
replace trendAvgemprate_Rcons`i' = trendAvgemprate_cons`i'/ lnemprate_peak_trough`i' if ifscode==`c' //new to calculate as function of the fall
drop pLemprate_cons //pL_beta
}
else {
replace trendAvgemprate_cons`i' = . if ifscode==`c'
replace trendAvgemprate_consp`i' = . if ifscode==`c'
}
drop regNemprate`i'

sum extrapolate_tempdiffemprateA`i' if ifscode==`c'
gen regNemprate`i' = r(N)
if regNemprate`i'>2 {
reg extrapolate_tempdiffemprateA`i' newt`i' if ifscode==`c'
test _b[_cons]=0
gen pAemprate_cons = r(p)
test _b[newt`i']=0
gen pAemprate_beta = r(p)
replace trendemprateA`i' = 2 if ifscode==`c' & pAemprate_beta<0.01 & _b[newt`i']>0
replace trendemprateA`i' = 1 if ifscode==`c' & pAemprate_beta>0.01 & _b[_cons]>0
replace trendemprateA`i' = 3 if ifscode==`c' & pAemprate_beta<0.01 & _b[_cons]>0 & _b[newt`i']<0
replace trendemprateA`i' = 4 if ifscode==`c' & pAemprate_beta<0.01 & _b[_cons]<0 & _b[newt`i']>0
replace trendemprateA`i' = 5 if ifscode==`c' & pAemprate_beta>0.01 & _b[_cons]<0
replace trendemprateA`i' = 6 if ifscode==`c' & pAemprate_beta<0.01 & _b[_cons]<0 & _b[newt`i']<0
replace trendemprateA_cons`i'  = _b[_cons] if ifscode==`c'
replace trendemprateA_consp`i' = pAemprate_cons   if ifscode==`c'
replace trendemprateA_beta`i'  = _b[newt`i'] if ifscode==`c'
replace trendemprateA_betap`i' = pAemprate_beta   if ifscode==`c'
replace trendemprateA_mndiff`i'= extrapolate_mndiffemprateA`i' if ifscode==`c'
drop pAemprate_cons pAemprate_beta
}
else {
replace trendemprateA`i' = . if ifscode==`c'
replace trendemprateA_cons`i' = . if ifscode==`c'
replace trendemprateA_consp`i' = . if ifscode==`c'
replace trendemprateA_beta`i' = . if ifscode==`c'
replace trendemprateA_betap`i' = . if ifscode==`c'
replace trendemprateA_mndiff`i'= . if ifscode==`c'
}
drop regNemprate`i'
}
*/
*/
}

sort ifscode date

/*
preserve
keep ifscode Country date recession lngdp extrapolate_reglngdp1 extrapolate_reglngdpA1 extrapolate_reglngdp2 extrapolate_reglngdpA2 extrapolate_reglngdp3 extrapolate_reglngdpA3 extrapolate_reglngdp4 extrapolate_reglngdpA4 extrapolate_reglngdp5 extrapolate_reglngdpA5 extrapolate_reglngdp6 extrapolate_reglngdpA6 extrapolate_reglngdp7 extrapolate_reglngdpA7 extrapolate_reglngdp8 extrapolate_reglngdpA8
save Extrapolations4Y.dta, replace
restore

twoway (line lngdp date) (line extrapolate_reglngdp1 date) (line extrapolate_reglngdpA1 date) (line extrapolate_reglngdp2 date) (line extrapolate_reglngdpA2 date) (line extrapolate_reglngdp3 date) (line extrapolate_reglngdpA3 date) (line extrapolate_reglngdp4 date) (line extrapolate_reglngdpA4 date) (line extrapolate_reglngdp5 date) (line extrapolate_reglngdpA5 date) (line extrapolate_reglngdp6 date) (line extrapolate_reglngdpA6 date) (line extrapolate_reglngdp7 date) (line extrapolate_reglngdpA7 date) (line extrapolate_reglngdp8 date) (line extrapolate_reglngdpA8 date) if ifscode==111, legend(off)
*/

/*
preserve
keep ifscode Country date recession lngdp extrapolate_reglngdp1 extrapolate_reglngdpA1 extrapolate_reglngdp2 extrapolate_reglngdpA2 extrapolate_reglngdp3 extrapolate_reglngdpA3 extrapolate_reglngdp4 extrapolate_reglngdpA4 extrapolate_reglngdp5 extrapolate_reglngdpA5 extrapolate_reglngdp6 extrapolate_reglngdpA6 extrapolate_reglngdp7 extrapolate_reglngdpA7 extrapolate_reglngdp8 extrapolate_reglngdpA8 lnprod extrapolate_reglnprod1 extrapolate_reglnprodA1 extrapolate_reglnprod2 extrapolate_reglnprodA2 extrapolate_reglnprod3 extrapolate_reglnprodA3 extrapolate_reglnprod4 extrapolate_reglnprodA4 extrapolate_reglnprod5 extrapolate_reglnprodA5 extrapolate_reglnprod6 extrapolate_reglnprodA6 extrapolate_reglnprod7 extrapolate_reglnprodA7 extrapolate_reglnprod8 extrapolate_reglnprodA8 lnemp extrapolate_reglnemp1 extrapolate_reglnempA1 extrapolate_reglnemp2 extrapolate_reglnempA2 extrapolate_reglnemp3 extrapolate_reglnempA3 extrapolate_reglnemp4 extrapolate_reglnempA4 extrapolate_reglnemp5 extrapolate_reglnempA5 extrapolate_reglnemp6 extrapolate_reglnempA6 extrapolate_reglnemp7 extrapolate_reglnempA7 extrapolate_reglnemp8 extrapolate_reglnempA8 lnlfp extrapolate_reglnlfp1 extrapolate_reglnlfpA1 extrapolate_reglnlfp2 extrapolate_reglnlfpA2 extrapolate_reglnlfp3 extrapolate_reglnlfpA3 extrapolate_reglnlfp4 extrapolate_reglnlfpA4 extrapolate_reglnlfp5 extrapolate_reglnlfpA5 extrapolate_reglnlfp6 extrapolate_reglnlfpA6 extrapolate_reglnlfp7 extrapolate_reglnlfpA7 extrapolate_reglnlfp8 extrapolate_reglnlfpA8 lnwap extrapolate_reglnwap1 extrapolate_reglnwapA1 extrapolate_reglnwap2 extrapolate_reglnwapA2 extrapolate_reglnwap3 extrapolate_reglnwapA3 extrapolate_reglnwap4 extrapolate_reglnwapA4 extrapolate_reglnwap5 extrapolate_reglnwapA5 extrapolate_reglnwap6 extrapolate_reglnwapA6 extrapolate_reglnwap7 extrapolate_reglnwapA7 extrapolate_reglnwap8 extrapolate_reglnwapA8 lnemprate extrapolate_reglnemprate1 extrapolate_reglnemprateA1 extrapolate_reglnemprate2 extrapolate_reglnemprateA2 extrapolate_reglnemprate3 extrapolate_reglnemprateA3 extrapolate_reglnemprate4 extrapolate_reglnemprateA4 extrapolate_reglnemprate5 extrapolate_reglnemprateA5 extrapolate_reglnemprate6 extrapolate_reglnemprateA6 extrapolate_reglnemprate7 extrapolate_reglnemprateA7 extrapolate_reglnemprate8 extrapolate_reglnemprateA8 
save Extrapolations4Y.dta, replace
restore

twoway (line lngdp date) (line extrapolate_reglngdp1 date) (line extrapolate_reglngdpA1 date) (line extrapolate_reglngdp2 date) (line extrapolate_reglngdpA2 date) (line extrapolate_reglngdp3 date) (line extrapolate_reglngdpA3 date) (line extrapolate_reglngdp4 date) (line extrapolate_reglngdpA4 date) (line extrapolate_reglngdp5 date) (line extrapolate_reglngdpA5 date) (line extrapolate_reglngdp6 date) (line extrapolate_reglngdpA6 date) (line extrapolate_reglngdp7 date) (line extrapolate_reglngdpA7 date) (line extrapolate_reglngdp8 date) (line extrapolate_reglngdpA8 date) if ifscode==111, legend(off)
*/

********************************************************************************
	//Generate Combination of episodes

gen combined_episode= ""
gen combined_trendAvg = .
gen combined_consAvg = .
gen combined_consRAvg = .
gen combined_conspAvg = .

gen combined_trendAvg_Rcons = .
gen combined_trendAvg_cons = .
gen recession_depth = .

gen combined_episodegdp= ""
gen combined_trendAvggdp = .
gen combined_consAvggdp = .
gen combined_consRAvggdp = .
gen combined_conspAvggdp = .

gen combined_trendAvggdp_Rcons = .
gen combined_trendAvggdp_cons = .
gen recession_depthgdp = .

gen combined_episodeemp= ""
gen combined_trendAvgemp = .
gen combined_consAvgemp = .
gen combined_consRAvgemp = .
gen combined_conspAvgemp = .

gen combined_trendAvgemp_Rcons = .
gen combined_trendAvgemp_cons = .
gen recession_depthemp = .

gen combined_episodeprod= ""
gen combined_trendAvgprod = .
gen combined_consAvgprod = .
gen combined_consRAvgprod = .
gen combined_conspAvgprod = .

gen combined_trendAvgprod_Rcons = .
gen combined_trendAvgprod_cons = .
gen recession_depthprod = .

/*
gen combined_episodewap= ""
gen combined_trendAvgwap = .
gen combined_consAvgwap = .
gen combined_consRAvgwap = .
gen combined_conspAvgwap = .

gen combined_trendAvgwap_Rcons = .
gen combined_trendAvgwap_cons = .
gen recession_depthwap = .

gen combined_episodelfp= ""
gen combined_trendAvglfp = .
gen combined_consAvglfp = .
gen combined_consRAvglfp = .
gen combined_conspAvglfp = .

gen combined_trendAvglfp_Rcons = .
gen combined_trendAvglfp_cons = .
gen recession_depthlfp = .

gen combined_episodeemprate= ""
gen combined_trendAvgemprate = .
gen combined_consAvgemprate = .
gen combined_consRAvgemprate = .
gen combined_conspAvgemprate = .

gen combined_trendAvgemprate_Rcons = .
gen combined_trendAvgemprate_cons = .
gen recession_depthemprate = .
*/

gen combined_trendA = .
gen combined_consA = .
gen combined_conspA = .
gen combined_betaA = .
gen combined_betapA = .

gen combined_trendgdpA = .
gen combined_consgdpA = .
gen combined_conspgdpA = .
gen combined_betagdpA = .
gen combined_betapgdpA = .

gen combined_trendempA = .
gen combined_consempA = .
gen combined_conspempA = .
gen combined_betaempA = .
gen combined_betapempA = .

gen combined_trendprodA = .
gen combined_consprodA = .
gen combined_conspprodA = .
gen combined_betaprodA = .
gen combined_betapprodA = .

/*
gen combined_trendwapA = .
gen combined_conswapA = .
gen combined_conspwapA = .
gen combined_betawapA = .
gen combined_betapwapA = .

gen combined_trendlfpA = .
gen combined_conslfpA = .
gen combined_consplfpA = .
gen combined_betalfpA = .
gen combined_betaplfpA = .

gen combined_trendemprateA = .
gen combined_consemprateA = .
gen combined_conspemprateA = .
gen combined_betaemprateA = .
gen combined_betapemprateA = .
*/


forval i = 1/`=YY[1]' {
replace combined_episode = episode`i' 			if combined_episode=="" & id`i'==1

replace combined_trendA  = trendA`i'  			if combined_trendA  ==. & id`i'==1
replace combined_consA   = trendA_cons`i'  		if combined_consA  ==. & id`i'==1
replace combined_conspA  = trendA_consp`i'  	if combined_conspA  ==. & id`i'==1
replace combined_betaA   = trendA_beta`i'  		if combined_betaA  ==. & id`i'==1
replace combined_betapA  = trendA_betap`i'  	if combined_betapA  ==. & id`i'==1

replace combined_trendAvg  = trendAvg`i'  		if combined_trendAvg  ==. & id`i'==1
replace combined_consAvg   = trendAvg_cons`i'  	if combined_consAvg  ==. & id`i'==1
replace combined_consRAvg  = trendAvg_Rcons`i'  if combined_consRAvg  ==. & id`i'==1
replace combined_conspAvg  = trendAvg_consp`i'  if combined_conspAvg  ==. & id`i'==1

replace combined_trendAvg_Rcons  = trendAvg_Rcons`i'  if combined_trendAvg_Rcons  ==. & id`i'==1
replace combined_trendAvg_cons  = trendAvg_cons`i'  if combined_trendAvg_cons  ==. & id`i'==1
replace recession_depth  = lrgdp_peak_trough`i'  if recession_depth  ==. & id`i'==1

replace combined_episodegdp = episode`i' 		if combined_episodegdp=="" & id`i'==1

replace combined_trendgdpA  = trendgdpA`i'  	if combined_trendgdpA  ==. & id`i'==1
replace combined_consgdpA   = trendgdpA_cons`i' if combined_consgdpA  ==. & id`i'==1
replace combined_conspgdpA  = trendgdpA_consp`i' if combined_conspgdpA  ==. & id`i'==1
replace combined_betagdpA   = trendgdpA_beta`i'  if combined_betagdpA  ==. & id`i'==1
replace combined_betapgdpA  = trendgdpA_betap`i' if combined_betapgdpA  ==. & id`i'==1

replace combined_trendAvggdp  = trendAvggdp`i'  	if combined_trendAvggdp  ==. & id`i'==1
replace combined_consAvggdp   = trendAvggdp_cons`i' if combined_consAvggdp  ==. & id`i'==1
replace combined_consRAvggdp  = trendAvggdp_Rcons`i'  if combined_consRAvggdp  ==. & id`i'==1
replace combined_conspAvggdp  = trendAvggdp_consp`i' if combined_conspAvggdp  ==. & id`i'==1

replace combined_trendAvggdp_Rcons  = trendAvggdp_Rcons`i'  if combined_trendAvggdp_Rcons  ==. & id`i'==1
replace combined_trendAvggdp_cons  = trendAvggdp_cons`i'  if combined_trendAvggdp_cons  ==. & id`i'==1
replace recession_depthgdp  = lngdp_peak_trough`i'  if recession_depthgdp  ==. & id`i'==1

replace combined_episodeemp = episode`i' 		if combined_episodeemp=="" & id`i'==1

replace combined_trendempA  = trendempA`i'  	if combined_trendempA  ==. & id`i'==1
replace combined_consempA   = trendempA_cons`i' if combined_consempA  ==. & id`i'==1
replace combined_conspempA  = trendempA_consp`i' if combined_conspempA  ==. & id`i'==1
replace combined_betaempA   = trendempA_beta`i'  if combined_betaempA  ==. & id`i'==1
replace combined_betapempA  = trendempA_betap`i' if combined_betapempA  ==. & id`i'==1

replace combined_trendAvgemp  = trendAvgemp`i'  	if combined_trendAvgemp  ==. & id`i'==1
replace combined_consAvgemp   = trendAvgemp_cons`i' if combined_consAvgemp  ==. & id`i'==1
replace combined_consRAvgemp  = trendAvgemp_Rcons`i'  if combined_consRAvgemp  ==. & id`i'==1
replace combined_conspAvgemp  = trendAvgemp_consp`i' if combined_conspAvgemp  ==. & id`i'==1

replace combined_trendAvgemp_Rcons  = trendAvgemp_Rcons`i'  if combined_trendAvgemp_Rcons  ==. & id`i'==1
replace combined_trendAvgemp_cons  = trendAvgemp_cons`i'  if combined_trendAvgemp_cons  ==. & id`i'==1
replace recession_depthemp  = lnemp_peak_trough`i'  if recession_depthemp  ==. & id`i'==1

replace combined_episodeprod = episode`i' 		if combined_episodeprod=="" & id`i'==1

replace combined_trendprodA  = trendprodA`i'  	if combined_trendprodA  ==. & id`i'==1
replace combined_consprodA   = trendprodA_cons`i' if combined_consprodA  ==. & id`i'==1
replace combined_conspprodA  = trendprodA_consp`i' if combined_conspprodA  ==. & id`i'==1
replace combined_betaprodA   = trendprodA_beta`i'  if combined_betaprodA  ==. & id`i'==1
replace combined_betapprodA  = trendprodA_betap`i' if combined_betapprodA  ==. & id`i'==1

replace combined_trendAvgprod  = trendAvgprod`i'  	if combined_trendAvgprod  ==. & id`i'==1
replace combined_consAvgprod   = trendAvgprod_cons`i' if combined_consAvgprod  ==. & id`i'==1
replace combined_consRAvgprod  = trendAvgprod_Rcons`i'  if combined_consRAvgprod  ==. & id`i'==1
replace combined_conspAvgprod  = trendAvgprod_consp`i' if combined_conspAvgprod  ==. & id`i'==1

replace combined_trendAvgprod_Rcons  = trendAvgprod_Rcons`i'  if combined_trendAvgprod_Rcons  ==. & id`i'==1
replace combined_trendAvgprod_cons  = trendAvgprod_cons`i'  if combined_trendAvgprod_cons  ==. & id`i'==1
replace recession_depthprod  = lnprod_peak_trough`i'  if recession_depthprod  ==. & id`i'==1


/*
//NEW
replace combined_episodewap = episode`i' 		if combined_episodewap=="" & id`i'==1

replace combined_trendwapA  = trendwapA`i'  	if combined_trendwapA  ==. & id`i'==1
replace combined_conswapA   = trendwapA_cons`i' if combined_conswapA  ==. & id`i'==1
replace combined_conspwapA  = trendwapA_consp`i' if combined_conspwapA  ==. & id`i'==1
replace combined_betawapA   = trendwapA_beta`i'  if combined_betawapA  ==. & id`i'==1
replace combined_betapwapA  = trendwapA_betap`i' if combined_betapwapA  ==. & id`i'==1

replace combined_trendAvgwap  = trendAvgwap`i'  	if combined_trendAvgwap  ==. & id`i'==1
replace combined_consAvgwap   = trendAvgwap_cons`i' if combined_consAvgwap  ==. & id`i'==1
replace combined_consRAvgwap  = trendAvgwap_Rcons`i'  if combined_consRAvgwap  ==. & id`i'==1
replace combined_conspAvgwap  = trendAvgwap_consp`i' if combined_conspAvgwap  ==. & id`i'==1

replace combined_trendAvgwap_Rcons  = trendAvgwap_Rcons`i'  if combined_trendAvgwap_Rcons  ==. & id`i'==1
replace combined_trendAvgwap_cons  = trendAvgwap_cons`i'  if combined_trendAvgwap_cons  ==. & id`i'==1
replace recession_depthwap  = lnwap_peak_trough`i'  if recession_depthwap  ==. & id`i'==1


replace combined_episodelfp = episode`i' 		if combined_episodelfp=="" & id`i'==1

replace combined_trendlfpA  = trendlfpA`i'  	if combined_trendlfpA  ==. & id`i'==1
replace combined_conslfpA   = trendlfpA_cons`i' if combined_conslfpA  ==. & id`i'==1
replace combined_consplfpA  = trendlfpA_consp`i' if combined_consplfpA  ==. & id`i'==1
replace combined_betalfpA   = trendlfpA_beta`i'  if combined_betalfpA  ==. & id`i'==1
replace combined_betaplfpA  = trendlfpA_betap`i' if combined_betaplfpA  ==. & id`i'==1

replace combined_trendAvglfp  = trendAvglfp`i'  	if combined_trendAvglfp  ==. & id`i'==1
replace combined_consAvglfp   = trendAvglfp_cons`i' if combined_consAvglfp  ==. & id`i'==1
replace combined_consRAvglfp  = trendAvglfp_Rcons`i'  if combined_consRAvglfp  ==. & id`i'==1
replace combined_conspAvglfp  = trendAvglfp_consp`i' if combined_conspAvglfp  ==. & id`i'==1

replace combined_trendAvglfp_Rcons  = trendAvglfp_Rcons`i'  if combined_trendAvglfp_Rcons  ==. & id`i'==1
replace combined_trendAvglfp_cons  = trendAvglfp_cons`i'  if combined_trendAvglfp_cons  ==. & id`i'==1
replace recession_depthlfp  = lnlfp_peak_trough`i'  if recession_depthlfp  ==. & id`i'==1


replace combined_episodeemprate = episode`i' 		if combined_episodeemprate=="" & id`i'==1

replace combined_trendemprateA  = trendemprateA`i'  	if combined_trendemprateA  ==. & id`i'==1
replace combined_consemprateA   = trendemprateA_cons`i' if combined_consemprateA  ==. & id`i'==1
replace combined_conspemprateA  = trendemprateA_consp`i' if combined_conspemprateA  ==. & id`i'==1
replace combined_betaemprateA   = trendemprateA_beta`i'  if combined_betaemprateA  ==. & id`i'==1
replace combined_betapemprateA  = trendemprateA_betap`i' if combined_betapemprateA  ==. & id`i'==1

replace combined_trendAvgemprate  = trendAvgemprate`i'  	if combined_trendAvgemprate  ==. & id`i'==1
replace combined_consAvgemprate   = trendAvgemprate_cons`i' if combined_consAvgemprate  ==. & id`i'==1
replace combined_consRAvgemprate  = trendAvgemprate_Rcons`i'  if combined_consRAvgemprate  ==. & id`i'==1
replace combined_conspAvgemprate  = trendAvgemprate_consp`i' if combined_conspAvgemprate  ==. & id`i'==1

replace combined_trendAvgemprate_Rcons  = trendAvgemprate_Rcons`i'  if combined_trendAvgemprate_Rcons  ==. & id`i'==1
replace combined_trendAvgemprate_cons  = trendAvgemprate_cons`i'  if combined_trendAvgemprate_cons  ==. & id`i'==1
replace recession_depthemprate  = lnemprate_peak_trough`i'  if recession_depthemprate  ==. & id`i'==1
*/

}
********************************************************************************

sort combined_episode
gen episode = combined_episode
merge m:1 episode using Episode_Included.dta
drop if _m==2
drop _m

gen combined_Avg=.

replace combined_Avg=2 if combined_consAvg>0 &  combined_trendA==2 // If average output gap positive and increasing and significant trend
replace combined_Avg=1 if combined_consAvg>0 &  combined_Avg==. & combined_trendA!=. // If average output gap positive but not significantly increasing
replace combined_Avg=3 if combined_Avg==. & combined_trendA!=. // If average output gap non positive

br combined_episode combined_consAvg combined_conspAvg combined_consRAvg combined_trendA combined_Avg combined_trendAvg_Rcons recession_depth if combined_episode!="" & included>=1 & Country!="Greece"

sort combined_episodegdp
gen episodegdp = combined_episodegdp
merge m:1 episode using Episode_Included.dta
drop if _m==2
drop _m

gen combined_Avggdp=.
replace combined_Avggdp=2 if combined_consAvggdp>0 &  combined_trendgdpA==2
replace combined_Avggdp=1 if combined_consAvggdp>0 &  combined_Avggdp==. & combined_trendgdpA!=.
replace combined_Avggdp=3 if combined_Avggdp==. & combined_trendgdpA!=.

br combined_episodegdp combined_consAvggdp combined_conspAvggdp combined_consRAvggdp combined_trendgdpA combined_Avggdp combined_trendAvggdp_Rcons recession_depthgdp if combined_episodegdp!="" & included>=1 & Country!="Greece"

sort combined_episodeemp
gen episodeemp = combined_episodeemp
merge m:1 episode using Episode_Included.dta
drop if _m==2
drop _m

gen combined_Avgemp=.
replace combined_Avgemp=2 if combined_consAvgemp>0 &  combined_trendempA==2
replace combined_Avgemp=1 if combined_consAvgemp>0 &  combined_Avgemp==. & combined_trendempA!=.
replace combined_Avgemp=3 if combined_Avgemp==. & combined_trendempA!=.

br combined_episodeemp combined_consAvgemp combined_conspAvgemp combined_consRAvgemp combined_trendempA combined_Avgemp combined_trendAvgemp_Rcons recession_depthemp if combined_episodeemp!="" & included>=1 & Country!="Greece"

sort combined_episodeprod
gen episodeprod = combined_episodeprod
merge m:1 episode using Episode_Included.dta
drop if _m==2
drop _m

gen combined_Avgprod=.
replace combined_Avgprod=2 if combined_consAvgprod>0 &  combined_trendprodA==2
replace combined_Avgprod=1 if combined_consAvgprod>0 &  combined_Avgprod==. & combined_trendprodA!=.
replace combined_Avgprod=3 if combined_Avgprod==. & combined_trendprodA!=.

br combined_episodeprod combined_consAvgprod combined_conspAvgprod combined_consRAvgprod combined_trendprodA combined_Avgprod combined_trendAvgprod_Rcons recession_depthprod if combined_episodeprod!="" & included>=1 & Country!="Greece"


/*
sort combined_episodewap
gen episodewap = combined_episodewap
merge m:1 episode using Episode_Included.dta
drop if _m==2
drop _m

gen combined_Avgwap=.
replace combined_Avgwap=2 if combined_consAvgwap>0 &  combined_trendwapA==2
replace combined_Avgwap=1 if combined_consAvgwap>0 &  combined_Avgwap==. & combined_trendwapA!=.
replace combined_Avgwap=3 if combined_Avgwap==. & combined_trendwapA!=.

br combined_episodewap combined_consAvgwap combined_conspAvgwap combined_consRAvgwap combined_trendwapA combined_Avgwap combined_trendAvgwap_Rcons recession_depthwap if combined_episodewap!="" & included>=1 & Country!="Greece"
histogram combined_consAvgwap if combined_episodewap!="" & included>=1 & Country!="Greece", width(.05) start(-.5) percent xtitle(Average wap Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average wap Output Gap") subtitle("(Log wap; 4 year Window; Benchmark)")


sort combined_episodelfp
gen episodelfp = combined_episodelfp
merge m:1 episode using Episode_Included.dta
drop if _m==2
drop _m

gen combined_Avglfp=.
replace combined_Avglfp=2 if combined_consAvglfp>0 &  combined_trendlfpA==2
replace combined_Avglfp=1 if combined_consAvglfp>0 &  combined_Avglfp==. & combined_trendlfpA!=.
replace combined_Avglfp=3 if combined_Avglfp==. & combined_trendlfpA!=.

br combined_episodelfp combined_consAvglfp combined_conspAvglfp combined_consRAvglfp combined_trendlfpA combined_Avglfp combined_trendAvglfp_Rcons recession_depthlfp if combined_episodelfp!="" & included>=1 & Country!="Greece"
histogram combined_consAvglfp if combined_episodelfp!="" & included>=1 & Country!="Greece", width(.05) start(-.5) percent xtitle(Average lfp Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average lfp Output Gap") subtitle("(Log lfp; 4 year Window; Benchmark)")


sort combined_episodeemprate
gen episodeemprate = combined_episodeemprate
merge m:1 episode using Episode_Included.dta
drop if _m==2
drop _m

gen combined_Avgemprate=.
replace combined_Avgemprate=2 if combined_consAvgemprate>0 &  combined_trendemprateA==2
replace combined_Avgemprate=1 if combined_consAvgemprate>0 &  combined_Avgemprate==. & combined_trendemprateA!=.
replace combined_Avgemprate=3 if combined_Avgemprate==. & combined_trendemprateA!=.

br combined_episodeemprate combined_consAvgemprate combined_conspAvgemprate combined_consRAvgemprate combined_trendemprateA combined_Avgemprate combined_trendAvgemprate_Rcons recession_depthemprate if combined_episodeemprate!="" & included>=1 & Country!="Greece"
histogram combined_consAvgemprate if combined_episodeemprate!="" & included>=1 & Country!="Greece", width(.05) start(-.5) percent xtitle(Average emprate Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average emprate Output Gap") subtitle("(Log emprate; 4 year Window; Benchmark)")
*/



/*
histogram combined_consAvggdp if combined_episodegdp!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(.05) percent xtitle(Average gdp Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average GDP Output Gap") subtitle("(Log GDP; 4 year Window; Benchmark)")
histogram combined_consAvgemp if combined_episodeemp!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(.05) percent xtitle(Average emp Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average EMP Output Gap") subtitle("(Log EMP; 4 year Window; Benchmark)")
histogram combined_consAvgprod if combined_episodeprod!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(.05) percent xtitle(Average prod Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average PROD Output Gap") subtitle("(Log PROD; 4 year Window; Benchmark)")
histogram combined_consRAvggdp if combined_episode!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(1) percent xtitle(Average OutputGap/OutputFall during  t1+12 - t1+27) xline(0) title("Average GDP Output Gap over Output Fall >2%") subtitle("(Log GDP; 4 year Window; Benchmark)")
histogram combined_consRAvgemp if combined_episode!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(1) percent xtitle(Average OutputGap/OutputFall during  t1+12 - t1+27) xline(0) title("Average EMP Output Gap over Output Fall >2%") subtitle("(Log EMP; 4 year Window; Benchmark)")
histogram combined_consRAvgprod if combined_episode!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(1) percent xtitle(Average OutputGap/OutputFall during  t1+12 - t1+27) xline(0) title("Average PROD Output Gap over Output Fall >2%") subtitle("(Log PROD; 4 year Window; Benchmark)")
*/

/*
histogram combined_consAvggdp if combined_episodegdp!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(.05) percent xtitle(Average gdp Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average GDP Output Gap") subtitle("(Log GDP; 4 year Window; Ajusted for Credit Booms)")
histogram combined_consAvgemp if combined_episodeemp!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(.05) percent xtitle(Average emp Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average EMP Output Gap") subtitle("(Log EMP; 4 year Window; Ajusted for Credit Booms)")
histogram combined_consAvgprod if combined_episodeprod!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(.05) percent xtitle(Average prod Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average PROD Output Gap") subtitle("(Log PROD; 4 year Window; Ajusted for Credit Booms)")
*/

/*
histogram combined_consAvgwap if combined_episodewap!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(.05) percent xtitle(Average wap Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average WAP Output Gap") subtitle("(Log wap; 4 year Window; Ajusted for Credit Booms)")
histogram combined_consAvglfp if combined_episodelfp!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(.05) percent xtitle(Average lfp Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average LFP Output Gap") subtitle("(Log lfp; 4 year Window; Ajusted for Credit Booms)")
histogram combined_consAvgemprate if combined_episodeemprate!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(.05) percent xtitle(Average emprate Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average EMPRATE Output Gap") subtitle("(Log emprate; 4 year Window; Ajusted for Credit Booms)")
*/

/*
histogram combined_consRAvggdp if combined_episode!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(1) percent xtitle(Average OutputGap/OutputFall during  t1+12 - t1+27) xline(0) title("Average GDP Output Gap over Output Fall >2%") subtitle("(Log GDP; 4 year Window; Ajusted for Credit Booms)")
histogram combined_consRAvgemp if combined_episode!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(1) percent xtitle(Average OutputGap/OutputFall during  t1+12 - t1+27) xline(0) title("Average EMP Output Gap over Output Fall >2%") subtitle("(Log EMP; 4 year Window; Ajusted for Credit Booms)")
histogram combined_consRAvgprod if combined_episode!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(1) percent xtitle(Average OutputGap/OutputFall during  t1+12 - t1+27) xline(0) title("Average PROD Output Gap over Output Fall >2%") subtitle("(Log PROD; 4 year Window; Ajusted for Credit Booms)")
*/

/*
histogram combined_consRAvgwap if combined_episode!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(1) percent xtitle(Average OutputGap/OutputFall during  t1+12 - t1+27) xline(0) title("Average WAP Output Gap over Output Fall >2%") subtitle("(Log wap; 4 year Window; Ajusted for Credit Booms)")
histogram combined_consRAvglfp if combined_episode!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(1) percent xtitle(Average OutputGap/OutputFall during  t1+12 - t1+27) xline(0) title("Average LFP Output Gap over Output Fall >2%") subtitle("(Log lfp; 4 year Window; Ajusted for Credit Booms)")
histogram combined_consRAvgemprate if combined_episode!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(1) percent xtitle(Average OutputGap/OutputFall during  t1+12 - t1+27) xline(0) title("Average EMPRATE Output Gap over Output Fall >2%") subtitle("(Log emprate; 4 year Window; Ajusted for Credit Booms)")
*/


/*
histogram combined_consAvggdp if combined_episodegdp!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(.05) percent xtitle(Average gdp Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average GDP Output Gap") subtitle("(Log GDP; 10 year Window; Benchmark)")
histogram combined_consAvgemp if combined_episodeemp!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(.05) percent xtitle(Average emp Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average EMP Output Gap") subtitle("(Log EMP; 10 year Window; Benchmark)")
histogram combined_consAvgprod if combined_episodeprod!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(.05) percent xtitle(Average prod Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average PROD Output Gap") subtitle("(Log PROD; 10 year Window; Benchmark)")
histogram combined_consRAvggdp if combined_episode!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(1) percent xtitle(Average OutputGap/OutputFall during  t1+12 - t1+27) xline(0) title("Average GDP Output Gap over Output Fall >2%") subtitle("(Log GDP; 10 year Window; Benchmark)")
histogram combined_consRAvgemp if combined_episode!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(1) percent xtitle(Average OutputGap/OutputFall during  t1+12 - t1+27) xline(0) title("Average EMP Output Gap over Output Fall >2%") subtitle("(Log EMP; 10 year Window; Benchmark)")
histogram combined_consRAvgprod if combined_episode!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(1) percent xtitle(Average OutputGap/OutputFall during  t1+12 - t1+27) xline(0) title("Average PROD Output Gap over Output Fall >2%") subtitle("(Log PROD; 10 year Window; Benchmark)")
*/


/*
histogram combined_consAvggdp if combined_episodegdp!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(.05) percent xtitle(Average gdp Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average GDP Output Gap") subtitle("(Log GDP; 10 year Window; Ajusted for Credit Booms)")
histogram combined_consAvgemp if combined_episodeemp!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(.05) percent xtitle(Average emp Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average EMP Output Gap") subtitle("(Log EMP; 10 year Window; Ajusted for Credit Booms)")
histogram combined_consAvgprod if combined_episodeprod!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(.05) percent xtitle(Average prod Output Gap during  t1+12 - t1+27) xline(0, lwidth(medthin) lcolor(black) extend) xmtick(##5, labels labsize(medsmall)) title("Average PROD Output Gap") subtitle("(Log PROD; 10 year Window; Ajusted for Credit Booms)")
histogram combined_consRAvggdp if combined_episode!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(1) percent xtitle(Average OutputGap/OutputFall during  t1+12 - t1+27) xline(0) title("Average GDP Output Gap over Output Fall >2%") subtitle("(Log GDP; 10 year Window; Ajusted for Credit Booms)")
histogram combined_consRAvgemp if combined_episode!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(1) percent xtitle(Average OutputGap/OutputFall during  t1+12 - t1+27) xline(0) title("Average EMP Output Gap over Output Fall >2%") subtitle("(Log EMP; 10 year Window; Ajusted for Credit Booms)")
histogram combined_consRAvgprod if combined_episode!="" & included>=1 & Country!="Greece" & recession_depth>0.02, width(1) percent xtitle(Average OutputGap/OutputFall during  t1+12 - t1+27) xline(0) title("Average PROD Output Gap over Output Fall >2%") subtitle("(Log PROD; 10 year Window; Ajusted for Credit Booms)")
*/

preserve

*keep ifscode lettercode year quarter date Country recession episode lngdp extrapolate_simpdiffgdp1 extrapolate_simpdiffgdp2 extrapolate_simpdiffgdp3 extrapolate_simpdiffgdp4 extrapolate_simpdiffgdp5 extrapolate_simpdiffgdp6 extrapolate_simpdiffgdp7 extrapolate_simpdiffgdp8 extrapolate_simpdiffgdp9 extrapolate_tempdiffgdpA1 extrapolate_tempdiffgdpA2 extrapolate_tempdiffgdpA3 extrapolate_tempdiffgdpA4 extrapolate_tempdiffgdpA5 extrapolate_tempdiffgdpA6 extrapolate_tempdiffgdpA7 extrapolate_tempdiffgdpA8 extrapolate_tempdiffgdpA9 lnemp extrapolate_simpdiffemp1 extrapolate_simpdiffemp2 extrapolate_simpdiffemp3 extrapolate_simpdiffemp4 extrapolate_simpdiffemp5 extrapolate_simpdiffemp6 extrapolate_simpdiffemp7 extrapolate_simpdiffemp8 extrapolate_simpdiffemp9 extrapolate_tempdiffempA1 extrapolate_tempdiffempA2 extrapolate_tempdiffempA3 extrapolate_tempdiffempA4 extrapolate_tempdiffempA5 extrapolate_tempdiffempA6 extrapolate_tempdiffempA7 extrapolate_tempdiffempA8 extrapolate_tempdiffempA9 lnprod extrapolate_simpdiffprod1 extrapolate_simpdiffprod2 extrapolate_simpdiffprod3 extrapolate_simpdiffprod4 extrapolate_simpdiffprod5 extrapolate_simpdiffprod6 extrapolate_simpdiffprod7 extrapolate_simpdiffprod8 extrapolate_simpdiffprod9 extrapolate_tempdiffprodA1 extrapolate_tempdiffprodA2 extrapolate_tempdiffprodA3 extrapolate_tempdiffprodA4 extrapolate_tempdiffprodA5 extrapolate_tempdiffprodA6 extrapolate_tempdiffprodA7 extrapolate_tempdiffprodA8 extrapolate_tempdiffprodA9 recession_depthgdp recession_depthemp recession_depthprod datemaxoutputdropA1 outputdropA1 diffoutputdropA1 maxoutputdropA1 datemaxoutputdropA2 outputdropA2 diffoutputdropA2 maxoutputdropA2 datemaxoutputdropA3 outputdropA3 diffoutputdropA3 maxoutputdropA3 datemaxoutputdropA4 outputdropA4 diffoutputdropA4 maxoutputdropA4 datemaxoutputdropA5 outputdropA5 diffoutputdropA5 maxoutputdropA5 datemaxoutputdropA6 outputdropA6 diffoutputdropA6 maxoutputdropA6 datemaxoutputdropA7 outputdropA7 diffoutputdropA7 maxoutputdropA7 datemaxoutputdropA8 outputdropA8 diffoutputdropA8 maxoutputdropA8 datemaxoutputdropA9 outputdropA9 diffoutputdropA9 maxoutputdropA9 lngdp_peak_trough1 lngdp_peak_trough2 lngdp_peak_trough3 lngdp_peak_trough4 lngdp_peak_trough5 lngdp_peak_trough6 lngdp_peak_trough7 lngdp_peak_trough8 lngdp_peak_trough9 maxGDPdropA1 maxGDPdropA2 maxGDPdropA3 maxGDPdropA4 maxGDPdropA5 maxGDPdropA6 maxGDPdropA7 maxGDPdropA8 maxGDPdropA9 maxoutputdropA1 maxoutputdropA2 maxoutputdropA3 maxoutputdropA4 maxoutputdropA5 maxoutputdropA6 maxoutputdropA7 maxoutputdropA8 maxoutputdropA9 lngdp_peak_trough1 lngdp_peak_trough2 lngdp_peak_trough3 lngdp_peak_trough4 lngdp_peak_trough5 lngdp_peak_trough6 lngdp_peak_trough7 lngdp_peak_trough8 lngdp_peak_trough9 nquartersmaxoutputdropA1 id1 nquartersmaxoutputdropA2 id2 nquartersmaxoutputdropA3 id3 nquartersmaxoutputdropA4 id4 nquartersmaxoutputdropA5 id5 nquartersmaxoutputdropA6 id6 nquartersmaxoutputdropA7 id7 nquartersmaxoutputdropA8 id8 nquartersmaxoutputdropA9 id9 lngdpgap12A1 lngdpgap27A1 lngdpgap12A2 lngdpgap27A2 lngdpgap12A3 lngdpgap27A3 lngdpgap12A4 lngdpgap27A4 lngdpgap12A5 lngdpgap27A5 lngdpgap12A6 lngdpgap27A6 lngdpgap12A7 lngdpgap27A7 lngdpgap12A8 lngdpgap27A8 lngdpgap12A9 lngdpgap27A9 diffextragdppeak1 diffextragdppeak2 diffextragdppeak3 diffextragdppeak4 diffextragdppeak5 diffextragdppeak6 diffextragdppeak7 diffextragdppeak8 diffextragdppeak9 lngdpgap20A1  lngdpgap20A2  lngdpgap20A3  lngdpgap20A4  lngdpgap20A5  lngdpgap20A6  lngdpgap20A7  lngdpgap20A8 lngdpgap20A9

//Need to add variables at the end
*keep ifscode lettercode year quarter date Country recession episode lngdp extrapolate_simpdiffgdp1 extrapolate_simpdiffgdp2 extrapolate_simpdiffgdp3 extrapolate_simpdiffgdp4 extrapolate_simpdiffgdp5 extrapolate_simpdiffgdp6 extrapolate_simpdiffgdp7 extrapolate_simpdiffgdp8 extrapolate_simpdiffgdp9 extrapolate_tempdiffgdpA1 extrapolate_tempdiffgdpA2 extrapolate_tempdiffgdpA3 extrapolate_tempdiffgdpA4 extrapolate_tempdiffgdpA5 extrapolate_tempdiffgdpA6 extrapolate_tempdiffgdpA7 extrapolate_tempdiffgdpA8 extrapolate_tempdiffgdpA9 lnemp extrapolate_simpdiffemp1 extrapolate_simpdiffemp2 extrapolate_simpdiffemp3 extrapolate_simpdiffemp4 extrapolate_simpdiffemp5 extrapolate_simpdiffemp6 extrapolate_simpdiffemp7 extrapolate_simpdiffemp8 extrapolate_simpdiffemp9 extrapolate_tempdiffempA1 extrapolate_tempdiffempA2 extrapolate_tempdiffempA3 extrapolate_tempdiffempA4 extrapolate_tempdiffempA5 extrapolate_tempdiffempA6 extrapolate_tempdiffempA7 extrapolate_tempdiffempA8 extrapolate_tempdiffempA9 lnprod extrapolate_simpdiffprod1 extrapolate_simpdiffprod2 extrapolate_simpdiffprod3 extrapolate_simpdiffprod4 extrapolate_simpdiffprod5 extrapolate_simpdiffprod6 extrapolate_simpdiffprod7 extrapolate_simpdiffprod8 extrapolate_simpdiffprod9 extrapolate_tempdiffprodA1 extrapolate_tempdiffprodA2 extrapolate_tempdiffprodA3 extrapolate_tempdiffprodA4 extrapolate_tempdiffprodA5 extrapolate_tempdiffprodA6 extrapolate_tempdiffprodA7 extrapolate_tempdiffprodA8 extrapolate_tempdiffprodA9 recession_depthgdp recession_depthemp recession_depthprod lnwap extrapolate_simpdiffwap1 extrapolate_simpdiffwap2 extrapolate_simpdiffwap3 extrapolate_simpdiffwap4 extrapolate_simpdiffwap5 extrapolate_simpdiffwap6 extrapolate_simpdiffwap7 extrapolate_simpdiffwap8 extrapolate_simpdiffwap9 extrapolate_tempdiffwapA1 extrapolate_tempdiffwapA2 extrapolate_tempdiffwapA3 extrapolate_tempdiffwapA4 extrapolate_tempdiffwapA5 extrapolate_tempdiffwapA6 extrapolate_tempdiffwapA7 extrapolate_tempdiffwapA8 extrapolate_tempdiffwapA9 lnemprate extrapolate_simpdiffemprate1 extrapolate_simpdiffemprate2 extrapolate_simpdiffemprate3 extrapolate_simpdiffemprate4 extrapolate_simpdiffemprate5 extrapolate_simpdiffemprate6 extrapolate_simpdiffemprate7 extrapolate_simpdiffemprate8 extrapolate_simpdiffemprate9 extrapolate_tempdiffemprateA1 extrapolate_tempdiffemprateA2 extrapolate_tempdiffemprateA3 extrapolate_tempdiffemprateA4 extrapolate_tempdiffemprateA5 extrapolate_tempdiffemprateA6 extrapolate_tempdiffemprateA7 extrapolate_tempdiffemprateA8 extrapolate_tempdiffemprateA9 lnlfp extrapolate_simpdifflfp1 extrapolate_simpdifflfp2 extrapolate_simpdifflfp3 extrapolate_simpdifflfp4 extrapolate_simpdifflfp5 extrapolate_simpdifflfp6 extrapolate_simpdifflfp7 extrapolate_simpdifflfp8 extrapolate_simpdifflfp9 extrapolate_tempdifflfpA1 extrapolate_tempdifflfpA2 extrapolate_tempdifflfpA3 extrapolate_tempdifflfpA4 extrapolate_tempdifflfpA5 extrapolate_tempdifflfpA6 extrapolate_tempdifflfpA7 extrapolate_tempdifflfpA8 extrapolate_tempdifflfpA9 recession_depthwap recession_depthemprate recession_depthlfp datemaxoutputdropA1 outputdropA1 diffoutputdropA1 maxoutputdropA1 datemaxoutputdropA2 outputdropA2 diffoutputdropA2 maxoutputdropA2 datemaxoutputdropA3 outputdropA3 diffoutputdropA3 maxoutputdropA3 datemaxoutputdropA4 outputdropA4 diffoutputdropA4 maxoutputdropA4 datemaxoutputdropA5 outputdropA5 diffoutputdropA5 maxoutputdropA5 datemaxoutputdropA6 outputdropA6 diffoutputdropA6 maxoutputdropA6 datemaxoutputdropA7 outputdropA7 diffoutputdropA7 maxoutputdropA7 datemaxoutputdropA8 outputdropA8 diffoutputdropA8 maxoutputdropA8 datemaxoutputdropA9 outputdropA9 diffoutputdropA9 maxoutputdropA9 lngdp_peak_trough1 lngdp_peak_trough2 lngdp_peak_trough3 lngdp_peak_trough4 lngdp_peak_trough5 lngdp_peak_trough6 lngdp_peak_trough7 lngdp_peak_trough8 lngdp_peak_trough9 maxGDPdropA1 maxGDPdropA2 maxGDPdropA3 maxGDPdropA4 maxGDPdropA5 maxGDPdropA6 maxGDPdropA7 maxGDPdropA8 maxGDPdropA9 maxoutputdropA1 maxoutputdropA2 maxoutputdropA3 maxoutputdropA4 maxoutputdropA5 maxoutputdropA6 maxoutputdropA7 maxoutputdropA8 maxoutputdropA9 lngdp_peak_trough1 lngdp_peak_trough2 lngdp_peak_trough3 lngdp_peak_trough4 lngdp_peak_trough5 lngdp_peak_trough6 lngdp_peak_trough7 lngdp_peak_trough8 lngdp_peak_trough9 nquartersmaxoutputdropA1 id1 nquartersmaxoutputdropA2 id2 nquartersmaxoutputdropA3 id3 nquartersmaxoutputdropA4 id4 nquartersmaxoutputdropA5 id5 nquartersmaxoutputdropA6 id6 nquartersmaxoutputdropA7 id7 nquartersmaxoutputdropA8 id8 nquartersmaxoutputdropA9 id9  lngdpgap12A1 lngdpgap27A1 lngdpgap12A2 lngdpgap27A2 lngdpgap12A3 lngdpgap27A3 lngdpgap12A4 lngdpgap27A4 lngdpgap12A5 lngdpgap27A5 lngdpgap12A6 lngdpgap27A6 lngdpgap12A7 lngdpgap27A7 lngdpgap12A8 lngdpgap27A8 lngdpgap12A9 lngdpgap27A9 diffextragdppeak1 diffextragdppeak2 diffextragdppeak3 diffextragdppeak4 diffextragdppeak5 diffextragdppeak6 diffextragdppeak7 diffextragdppeak8 diffextragdppeak9 lngdpgap20A1  lngdpgap20A2  lngdpgap20A3  lngdpgap20A4  lngdpgap20A5  lngdpgap20A6  lngdpgap20A7  lngdpgap20A8 lngdpgap20A9 

sort Country date
save FinalData4Yadj.dta, replace

restore



********************************************************************************
********************************************************************************
									*Analysis 
********************************************************************************
********************************************************************************

cd "C:\Users\Thomas.Pellet\OneDrive - Peterson Institute for International Economics\2017-11\JEP OB paper natural rate\Figure 4c"
use FinalData4Yadj.dta, clear 


forval x = 1/`=YY[1]' {
gen gdpgap`x' = .
gen gdpgap_trend`x' = .

gen gdpgapA`x' = .
gen gdpgapA_trend`x' = .

gen gdpdropA`x' = .
gen gdpdropAbis`x' = .
gen gdpdrop`x' = .

gen empdrop`x' = .
gen proddrop`x' = .
gen empratedrop`x' = .
gen lfpdrop`x' = .
gen wapdrop`x' = .

gen gdpdropA_trend`x' = .
gen gdpdropAbis_trend`x' = .
gen gdpdrop_trend`x' = .

gen empgap`x' = .
gen empgapA`x' = .

gen prodgap`x' = .
gen prodgapA`x' = .


gen gdpgap12`x' = .
gen gdpgap27`x' = .
gen gdpgap20`x' = .

gen gdpgap12_trend`x' = .
gen gdpgap27_trend`x' = .
gen gdpgap20_trend`x' = .


gen gdpgap12A`x' = .
gen gdpgap27A`x' = .
gen gdpgap20A`x' = .

gen gdpgap12A_trend`x' = .
gen gdpgap27A_trend`x' = .
gen gdpgap20A_trend`x' = .


gen nqmaxgdpdropA`x' = .
gen diffextragdppeakA`x' = .

gen nqmaxgdpdropA_trend`x' = .
gen diffextragdppeakA_trend`x' = .


gen empgap12A`x' = .
gen empgap27A`x' = .
gen empgap20A`x' = .

gen nqmaxempdropA`x' = .
gen diffextraemppeakA`x' = .

gen prodgap12A`x' = .
gen prodgap27A`x' = .
gen prodgap20A`x' = .

gen nqmaxproddropA`x' = .
gen diffextraprodpeakA`x' = .


gen wapgap`x' = .
gen wapgapA`x' = .

gen lfpgap`x' = .
gen lfpgapA`x' = .

gen emprategap`x' = .
gen emprategapA`x' = .


gen wapgap12A`x' = .
gen wapgap27A`x' = .
gen wapgap20A`x' = .

gen nqmaxwapdropA`x' = .
gen diffextrawappeakA`x' = .

gen lfpgap12A`x' = .
gen lfpgap27A`x' = .
gen lfpgap20A`x' = .

gen nqmaxlfpdropA`x' = .
gen diffextralfppeakA`x' = .

gen emprategap12A`x' = .
gen emprategap27A`x' = .
gen emprategap20A`x' = .

gen nqmaxempratedropA`x' = .
gen diffextraempratepeakA`x' = .
}



// gdpgap: average output gap 3 to 7 years after trough
// gdpgapA: average output gap 3 to 7 years after trough - adjusted for quadratic trend
// gdpdrop: peak - trough
// gdpdropA: max output drop between extrapolated trend and actual gdp up to 3 years after trough
// gdpdropAbis: max value between the two measures of gdp drop described before



levelsof ifscode, local(codes)
foreach i in `codes' {
forval x = 1/`=YY[1]' {
egen tgdpgap`x' = mean(extrapolate_simpdiffgdp`x') if ifscode==`i'
replace gdpgap`x' = tgdpgap`x' if ifscode==`i'
drop tgdpgap`x'

egen tgdpgap_trend`x' = mean(extrapolate_simpdiff_trend`x') if ifscode==`i'
replace gdpgap_trend`x' = tgdpgap_trend`x' if ifscode==`i'
drop tgdpgap_trend`x'


egen tgdpgapA`x' = mean(extrapolate_tempdiffgdpA`x') if ifscode==`i'
replace gdpgapA`x' = tgdpgapA`x' if ifscode==`i'
drop tgdpgapA`x'

egen tgdpgapA_trend`x' = mean(extrapolate_tempdiffA_trend`x') if ifscode==`i'
replace gdpgapA_trend`x' = tgdpgapA_trend`x' if ifscode==`i'
drop tgdpgapA_trend`x'


egen tgdpdropA`x' = mean(maxoutputdropA`x') if ifscode==`i'
replace gdpdropA`x' = tgdpdropA`x' if ifscode==`i'
drop tgdpdropA`x'

egen tgdpdropAbis`x' = mean(maxGDPdropA`x') if ifscode==`i'
replace gdpdropAbis`x' = tgdpdropAbis`x' if ifscode==`i'
drop tgdpdropAbis`x'

egen tgdpdrop`x' = mean(lrgdp_peak_trough`x') if ifscode==`i'
replace gdpdrop`x' = tgdpdrop`x' if ifscode==`i'
drop tgdpdrop`x'


egen tempdrop`x' = mean(lnemp_peak_trough`x') if ifscode==`i'
replace empdrop`x' = tempdrop`x' if ifscode==`i'
drop tempdrop`x'

egen tproddrop`x' = mean(lnprod_peak_trough`x') if ifscode==`i'
replace proddrop`x' = tproddrop`x' if ifscode==`i'
drop tproddrop`x'

egen tempratedrop`x' = mean(lnemprate_peak_trough`x') if ifscode==`i'
replace empratedrop`x' = tempratedrop`x' if ifscode==`i'
drop tempratedrop`x'

egen twapdrop`x' = mean(lnwap_peak_trough`x') if ifscode==`i'
replace wapdrop`x' = twapdrop`x' if ifscode==`i'
drop twapdrop`x'

egen tlfpdrop`x' = mean(lnlfp_peak_trough`x') if ifscode==`i'
replace lfpdrop`x' = tlfpdrop`x' if ifscode==`i'
drop tlfpdrop`x'



egen tgdpgap12A`x' = mean(lrgdpgap12A`x') if ifscode==`i'
replace gdpgap12A`x' = tgdpgap12A`x' if ifscode==`i'
drop tgdpgap12A`x'

egen tgdpgap27A`x' = mean(lrgdpgap27A`x') if ifscode==`i'
replace gdpgap27A`x' = tgdpgap27A`x' if ifscode==`i'
drop tgdpgap27A`x'

egen tgdpgap20A`x' = mean(lrgdpgap20A`x') if ifscode==`i'
replace gdpgap20A`x' = tgdpgap20A`x' if ifscode==`i'
drop tgdpgap20A`x'


egen tgdpdropA_trend`x' = mean(maxoutputdropA_trend`x') if ifscode==`i'
replace gdpdropA_trend`x' = tgdpdropA_trend`x' if ifscode==`i'
drop tgdpdropA_trend`x'

egen tgdpdropAbis_trend`x' = mean(maxGDPdropA_trend`x') if ifscode==`i'
replace gdpdropAbis_trend`x' = tgdpdropAbis_trend`x' if ifscode==`i'
drop tgdpdropAbis_trend`x'

egen tgdpgap12A_trend`x' = mean(lrgdpgap12A_trend`x') if ifscode==`i'
replace gdpgap12A_trend`x' = tgdpgap12A_trend`x' if ifscode==`i'
drop tgdpgap12A_trend`x'

egen tgdpgap27A_trend`x' = mean(lrgdpgap27A_trend`x') if ifscode==`i'
replace gdpgap27A_trend`x' = tgdpgap27A_trend`x' if ifscode==`i'
drop tgdpgap27A_trend`x'

egen tgdpgap20A_trend`x' = mean(lrgdpgap20A_trend`x') if ifscode==`i'
replace gdpgap20A_trend`x' = tgdpgap20A_trend`x' if ifscode==`i'
drop tgdpgap20A_trend`x'


egen tnqmaxgdpdropA`x' = mean(nquartersmaxoutputdropA`x') if ifscode==`i'
replace nqmaxgdpdropA`x' = tnqmaxgdpdropA`x' if ifscode==`i'
drop tnqmaxgdpdropA`x'

egen tdiffextragdppeakA`x' = mean(diffextragdppeak`x') if ifscode==`i'
replace diffextragdppeakA`x' = tdiffextragdppeakA`x' if ifscode==`i'
drop tdiffextragdppeakA`x'

egen tnqmaxgdpdropA_trend`x' = mean(nquartersmaxoutputdropA_trend`x') if ifscode==`i'
replace nqmaxgdpdropA_trend`x' = tnqmaxgdpdropA_trend`x' if ifscode==`i'
drop tnqmaxgdpdropA_trend`x'

egen tdiffextragdppeakA_trend`x' = mean(diffextragdppeak_trend`x') if ifscode==`i'
replace diffextragdppeakA_trend`x' = tdiffextragdppeakA_trend`x' if ifscode==`i'
drop tdiffextragdppeakA_trend`x'




egen tempgap`x' = mean(extrapolate_simpdiffemp`x') if ifscode==`i'
replace empgap`x' = tempgap`x' if ifscode==`i'
drop tempgap`x'

egen tempgapA`x' = mean(extrapolate_tempdiffempA`x') if ifscode==`i'
replace empgapA`x' = tempgapA`x' if ifscode==`i'
drop tempgapA`x'

egen tprodgap`x' = mean(extrapolate_simpdiffprod`x') if ifscode==`i'
replace prodgap`x' = tprodgap`x' if ifscode==`i'
drop tprodgap`x'

egen tprodgapA`x' = mean(extrapolate_tempdiffprodA`x') if ifscode==`i'
replace prodgapA`x' = tprodgapA`x' if ifscode==`i'
drop tprodgapA`x'


********************************************************************************

//NEW
egen twapgap`x' = mean(extrapolate_simpdiffwap`x') if ifscode==`i'
replace wapgap`x' = twapgap`x' if ifscode==`i'
drop twapgap`x'

egen twapgapA`x' = mean(extrapolate_tempdiffwapA`x') if ifscode==`i'
replace wapgapA`x' = twapgapA`x' if ifscode==`i'
drop twapgapA`x'

egen tlfpgap`x' = mean(extrapolate_simpdifflfp`x') if ifscode==`i'
replace lfpgap`x' = tlfpgap`x' if ifscode==`i'
drop tlfpgap`x'

egen tlfpgapA`x' = mean(extrapolate_tempdifflfpA`x') if ifscode==`i'
replace lfpgapA`x' = tlfpgapA`x' if ifscode==`i'
drop tlfpgapA`x'

egen temprategap`x' = mean(extrapolate_simpdiffemprate`x') if ifscode==`i'
replace emprategap`x' = temprategap`x' if ifscode==`i'
drop temprategap`x'

egen temprategapA`x' = mean(extrapolate_tempdiffemprateA`x') if ifscode==`i'
replace emprategapA`x' = temprategapA`x' if ifscode==`i'
drop temprategapA`x'

}
}
keep if episode != ""

merge 1:1 episode using Episode_id.dta, nogen
sort Country episodeid

gen gdpgap4Y = .
gen gdpgap4Y_trend = .

gen gdpgapA4Y = .
gen gdpgapA4Y_trend = .

gen gdpdropA4Y = .
gen gdpdropAbis4Y = .
gen gdpdrop4Y = .


gen proddrop4Y = .
gen empdrop4Y = .
gen empratedrop4Y = .
gen lfpdrop4Y = .
gen wapdrop4Y = .


gen gdpdropA4Y_trend = .
gen gdpdropAbis4Y_trend = .

gen gdpgap12A4Y=.
gen gdpgap27A4Y=.
gen gdpgap20A4Y=.

gen gdpgap12A4Y_trend=.
gen gdpgap27A4Y_trend=.
gen gdpgap20A4Y_trend=.

gen diffextragdppeakA4Y=.
gen nqmaxgdpdropA4Y=.

gen diffextragdppeakA4Y_trend=.
gen nqmaxgdpdropA4Y_trend=.

gen empgap4Y = .
gen empgapA4Y = .

gen prodgap4Y = .
gen prodgapA4Y = .

gen wapgap4Y= .
gen wapgapA4Y= .

gen lfpgap4Y= .
gen lfpgapA4Y= .

gen emprategap4Y= .
gen emprategapA4Y= .


drop if included == .   // New   


forval x = 1/`=YY[1]' {
by Country : replace gdpgap4Y = gdpgap`x' if episodeid == `x'
by Country : replace gdpgap4Y_trend = gdpgap_trend`x' if episodeid == `x'

by Country : replace gdpgapA4Y = gdpgapA`x' if episodeid == `x'
by Country : replace gdpdropA4Y = gdpdropA`x' if episodeid == `x'
by Country : replace gdpdropAbis4Y = gdpdropAbis`x' if episodeid == `x'
by Country : replace gdpgapA4Y_trend = gdpgapA_trend`x' if episodeid == `x'
by Country : replace gdpdropA4Y_trend = gdpdropA_trend`x' if episodeid == `x'
by Country : replace gdpdropAbis4Y_trend = gdpdropAbis_trend`x' if episodeid == `x'

by Country : replace gdpdrop4Y = gdpdrop`x' if episodeid == `x'

by Country : replace proddrop4Y = proddrop`x' if episodeid == `x'
by Country : replace empdrop4Y = empdrop`x' if episodeid == `x'
by Country : replace empratedrop4Y = empratedrop`x' if episodeid == `x'
by Country : replace lfpdrop4Y = lfpdrop`x' if episodeid == `x'
by Country : replace wapdrop4Y = wapdrop`x' if episodeid == `x'

by Country : replace gdpgap12A4Y = gdpgap12A`x' if episodeid == `x'
by Country : replace gdpgap27A4Y = gdpgap27A`x' if episodeid == `x'
by Country : replace gdpgap20A4Y = gdpgap20A`x' if episodeid == `x'

by Country : replace gdpgap12A4Y_trend = gdpgap12A_trend`x' if episodeid == `x'
by Country : replace gdpgap27A4Y_trend = gdpgap27A_trend`x' if episodeid == `x'
by Country : replace gdpgap20A4Y_trend = gdpgap20A_trend`x' if episodeid == `x'

by Country : replace diffextragdppeakA4Y = diffextragdppeakA`x' if episodeid == `x'
by Country : replace nqmaxgdpdropA4Y = nqmaxgdpdropA`x'  if episodeid == `x'

by Country : replace diffextragdppeakA4Y_trend = diffextragdppeakA_trend`x' if episodeid == `x'
by Country : replace nqmaxgdpdropA4Y_trend = nqmaxgdpdropA_trend`x'  if episodeid == `x'



by Country : replace empgap4Y = empgap`x' if episodeid == `x'
by Country : replace empgapA4Y = empgapA`x' if episodeid == `x'

by Country : replace prodgap4Y = prodgap`x' if episodeid == `x'
by Country : replace prodgapA4Y = prodgapA`x' if episodeid == `x'


by Country : replace wapgap4Y = wapgap`x' if episodeid == `x'
by Country : replace wapgapA4Y = wapgapA`x' if episodeid == `x'

by Country : replace lfpgap4Y = lfpgap`x' if episodeid == `x'
by Country : replace lfpgapA4Y = lfpgapA`x' if episodeid == `x'


by Country : replace emprategap4Y = emprategap`x' if episodeid == `x'
by Country : replace emprategapA4Y = emprategapA`x' if episodeid == `x'


}

merge 1:1 episode using Episode_Included.dta, nogen

drop if included == .
drop if included == 0

gen test = gdpgap4Y - empgap4Y - prodgap4Y
gen included_bis=1 if abs(test)<0.01
drop test
drop if included_bis !=1
drop included_bis

keep ifscode Country episode episodeid gdpgap4Y gdpgap4Y_trend gdpgapA4Y gdpgapA4Y_trend gdpdropA4Y gdpdropAbis4Y gdpdropA4Y_trend gdpdropAbis4Y_trend gdpdrop4Y empdrop4Y proddrop4Y empratedrop4Y wapdrop4Y lfpdrop4Y gdpgap12A4Y gdpgap27A4Y gdpgap20A4Y gdpgap12A4Y_trend gdpgap27A4Y_trend gdpgap20A4Y_trend   empgap4Y empgapA4Y prodgap4Y prodgapA4Y recession_depthgdp recession_depthemp recession_depthprod gdpgap12A4Y gdpgap27A4Y gdpgap20A4Y diffextragdppeakA4Y nqmaxgdpdropA4Y diffextragdppeakA4Y_trend nqmaxgdpdropA4Y_trend wapgap4Y wapgapA4Y lfpgap4Y lfpgapA4Y emprategap4Y emprategapA4Y // recession_depthwap recession_depthlfp recession_depthemprate
merge 1:1 episode using Type_recession.dta, nogen // Typeofrecessions.dta comes from appendix in BCS paper, Type_recession is the outcome obtained from running this code (see part 2. above)
//Type_variables from this code, other variables from BCS


drop if ifscode== 196
drop if gdpgap4Y==.

gen recessionlength = 1 if lgdp_duration>=4
replace recessionlength = 0 if recessionlength ==.

gen recessiondepth = 1 if recession_depthgdp>=0.05
replace recessiondepth = 0 if recessiondepth ==.


gen gdpgap2712A4Y = gdpgap27A4Y - gdpgap12A4Y
gen gdpgap2012A4Y = gdpgap20A4Y - gdpgap12A4Y

gen gdpgap2712ratioA4Y = gdpgap27A4Y/gdpgap12A4Y
gen gdpgap2012ratioA4Y = gdpgap20A4Y/gdpgap12A4Y

gen gdpgap2712A4Y_trend = gdpgap27A4Y_trend - gdpgap12A4Y_trend
gen gdpgap2012A4Y_trend = gdpgap20A4Y_trend - gdpgap12A4Y_trend

gen gdpgap2712ratioA4Y_trend = gdpgap27A4Y_trend/gdpgap12A4Y_trend
gen gdpgap2012ratioA4Y_trend = gdpgap20A4Y_trend/gdpgap12A4Y_trend

gen negative=1 if gdpgapA4Y<0
replace negative=0 if negative==. 

*gen gdpgap12Adrop = gdpgap12A4Y+recession_depthgdp
*gen gdpgap12Amaxdrop = gdpgap12A4Y+gdpdropAbis4Y

save FinalData4Yadj_gap.dta, replace

gen estwindow=window
gen gapstart=wstart
gen gapend=wend

gen line=_n

preserve
keep if intentionaldisinflation==1 //disinflations only
save FinalData4Yadj_gap_disinfl_w`nw'_s`ns'.dta, replace //disinflations only
*save FinalData4Yadj_gap_disinfl_w`nw'_s`ns'.dta, replace //disinflations only
restore

gen ratio_gdp=gdpgapA4Y/gdpdrop4Y //new

gen ratio_prod=prodgapA4Y/proddrop4Y //new
gen ratio_emp=empgapA4Y/empdrop4Y //new
gen ratio_emprate=emprategapA4Y/empratedrop4Y //new
gen ratio_lfp=lfpgapA4Y/lfpdrop4Y //new
gen ratio_wap=wapgapA4Y/wapdrop4Y //new


local var "gdp emp prod wap lfp emprate"
foreach varx of local var{

egen meangap_`varx'=mean(`varx'gapA4Y)
*gen meangap=tmeangap

egen sdgap_`varx'=sd(`varx'gapA4Y)
*gen sdgap=tsdgap

egen meanratio_`varx'=mean(ratio_`varx')

}

egen count_gdp=max(line)
*gen count=tcount

egen countn_gdp=sum(negative)


gen infl = Type_Inflation
gen oil = Type_Oilprice
gen oilBCS = increasingoilprice
gen fin = Type_Systemic
gen finBCS = financialcrisis
gen disinfl = intentionaldisinflation
gen length = recessionlength
gen depth = recessiondepth

local var "gdp emp prod wap lfp emprate"
local type "infl oil oilBCS fin finBCS disinfl length depth"

foreach varx of local var{
foreach typex of local type{

egen tmeangap_`varx'_`typex'=mean(`varx'gapA4Y) if `typex'==1
gen meangapbis_`varx'_`typex'=tmeangap_`varx'_`typex'
egen meangap_`varx'_`typex'=mean(meangapbis_`varx'_`typex')

egen tsdgap_`varx'_`typex'=sd(`varx'gapA4Y) if `typex'==1
gen sdgapbis_`varx'_`typex'=tsdgap_`varx'_`typex'
egen sdgap_`varx'_`typex'=mean(sdgapbis_`varx'_`typex')

egen tcount_`varx'_`typex'=count(`varx'gapA4Y) if `typex'==1
gen tcountbis_`varx'_`typex'= tcount_`varx'_`typex'
egen count_`varx'_`typex'=mean(tcountbis_`varx'_`typex')
*gen count_`varx'_`typex'=tmeangap_`varx'_`typex'_bis

egen tcountn_`varx'_`typex'=count(`varx'gapA4Y) if `typex'==1 & negative==1
gen tcountbisn_`varx'_`typex'= tcountn_`varx'_`typex'
egen countn_`varx'_`typex'=mean(tcountbisn_`varx'_`typex')

egen tmeanratio_`varx'_`typex'=mean(ratio_`varx') if `typex'==1
gen meanratiobis_`varx'_`typex'=tmeanratio_`varx'_`typex'
egen meanratio_`varx'_`typex'=mean(meanratiobis_`varx'_`typex')

drop tmeanratio_`varx'_`typex' meanratiobis_`varx'_`typex'
drop tmeangap_`varx'_`typex' meangapbis_`varx'_`typex' tsdgap_`varx'_`typex' sdgapbis_`varx'_`typex' tcount_`varx'_`typex' tcountbis_`varx'_`typex' tcountn_`varx'_`typex' tcountbisn_`varx'_`typex'

}
}


keep if line==1
*keep estwindow gapstart gapend meangap sdgap count

save FinalData4Yadj_gap_w`nw'_s`ns'.dta, replace
}
}


*********************************************
use FinalData4Yadj_gap_w4_s3.dta
forval nw = 4/10 {
forval ns = 3/10 { //change
append using FinalData4Yadj_gap_w`nw'_s`ns'.dta
save FinalData4Yadj_gap_w4_s3.dta, replace
*erase FinalData4Yadj_gap_w`nw'_s`ns'.dta
}
}

*save FinalData4Yadj_gap_matrix.dta, replace

drop Country negative ifscode recession_depthgdp recession_depthemp recession_depthprod episode episodeid gdpgap4Y gdpgap4Y_trend gdpgapA4Y gdpgapA4Y_trend gdpdropA4Y gdpdropAbis4Y gdpdrop4Y gdpdropA4Y_trend gdpdropAbis4Y_trend gdpgap12A4Y gdpgap27A4Y gdpgap20A4Y gdpgap12A4Y_trend gdpgap27A4Y_trend gdpgap20A4Y_trend diffextragdppeakA4Y nqmaxgdpdropA4Y diffextragdppeakA4Y_trend nqmaxgdpdropA4Y_trend empgap4Y empgapA4Y prodgap4Y prodgapA4Y wapgap4Y wapgapA4Y lfpgap4Y lfpgapA4Y emprategap4Y emprategapA4Y lrgdp_duration Type_Distress Type_Systemic Type_Inflation Type_Oilprice lgdp_duration financialcrisis increasingoilprice increasinginflation intentionaldisinflation Type_DisInflation old_episode recessionlength recessiondepth gdpgap2712A4Y gdpgap2012A4Y gdpgap2712ratioA4Y gdpgap2012ratioA4Y gdpgap2712A4Y_trend gdpgap2012A4Y_trend gdpgap2712ratioA4Y_trend gdpgap2012ratioA4Y_trend line  oil oilBCS fin finBCS disinfl length depth
drop in 1

save FinalData4Yadj_gap_matrix.dta, replace

*erase FinalData4Yadj_gap_w4_s3.dta

drop proddrop4Y	empdrop4Y	empratedrop4Y	lfpdrop4Y	wapdrop4Y	ratio_gdp	ratio_prod	ratio_emp	ratio_emprate	ratio_lfp	ratio_wap
drop gapend

*reshape wide meangap_gdp	sdgap_gdp	meangap_emp	sdgap_emp	meangap_prod	sdgap_prod	meangap_wap	sdgap_wap	meangap_lfp	sdgap_lfp	meangap_emprate	sdgap_emprate	count_gdp	countn_gdp	meanratio_gdp	meangap_gdp_infl	sdgap_gdp_infl	count_gdp_infl	countn_gdp_infl	meangap_gdp_oil	sdgap_gdp_oil	count_gdp_oil	countn_gdp_oil	meangap_gdp_oilBCS	sdgap_gdp_oilBCS	count_gdp_oilBCS	countn_gdp_oilBCS	meangap_gdp_fin	sdgap_gdp_fin	count_gdp_fin	countn_gdp_fin	meangap_gdp_finBCS	sdgap_gdp_finBCS	count_gdp_finBCS	countn_gdp_finBCS	meangap_gdp_disinfl	sdgap_gdp_disinfl	count_gdp_disinfl	countn_gdp_disinfl	meangap_gdp_length	sdgap_gdp_length	count_gdp_length	countn_gdp_length	meangap_gdp_depth	sdgap_gdp_depth	count_gdp_depth	countn_gdp_depth	meangap_emp_infl	sdgap_emp_infl	count_emp_infl	countn_emp_infl	meangap_emp_oil	sdgap_emp_oil	count_emp_oil	countn_emp_oil	meangap_emp_oilBCS	sdgap_emp_oilBCS	count_emp_oilBCS	countn_emp_oilBCS	meangap_emp_fin	sdgap_emp_fin	count_emp_fin	countn_emp_fin	meangap_emp_finBCS	sdgap_emp_finBCS	count_emp_finBCS	countn_emp_finBCS	meangap_emp_disinfl	sdgap_emp_disinfl	count_emp_disinfl	countn_emp_disinfl	meangap_emp_length	sdgap_emp_length	count_emp_length	countn_emp_length	meangap_emp_depth	sdgap_emp_depth	count_emp_depth	countn_emp_depth	meangap_prod_infl	sdgap_prod_infl	count_prod_infl	countn_prod_infl	meangap_prod_oil	sdgap_prod_oil	count_prod_oil	countn_prod_oil	meangap_prod_oilBCS	sdgap_prod_oilBCS	count_prod_oilBCS	countn_prod_oilBCS	meangap_prod_fin	sdgap_prod_fin	count_prod_fin	countn_prod_fin	meangap_prod_finBCS	sdgap_prod_finBCS	count_prod_finBCS	countn_prod_finBCS	meangap_prod_disinfl	sdgap_prod_disinfl	count_prod_disinfl	countn_prod_disinfl	meangap_prod_length	sdgap_prod_length	count_prod_length	countn_prod_length	meangap_prod_depth	sdgap_prod_depth	count_prod_depth	countn_prod_depth	meangap_wap_infl	sdgap_wap_infl	count_wap_infl	countn_wap_infl	meangap_wap_oil	sdgap_wap_oil	count_wap_oil	countn_wap_oil	meangap_wap_oilBCS	sdgap_wap_oilBCS	count_wap_oilBCS	countn_wap_oilBCS	meangap_wap_fin	sdgap_wap_fin	count_wap_fin	countn_wap_fin	meangap_wap_finBCS	sdgap_wap_finBCS	count_wap_finBCS	countn_wap_finBCS	meangap_wap_disinfl	sdgap_wap_disinfl	count_wap_disinfl	countn_wap_disinfl	meangap_wap_length	sdgap_wap_length	count_wap_length	countn_wap_length	meangap_wap_depth	sdgap_wap_depth	count_wap_depth	countn_wap_depth	meangap_lfp_infl	sdgap_lfp_infl	count_lfp_infl	countn_lfp_infl	meangap_lfp_oil	sdgap_lfp_oil	count_lfp_oil	countn_lfp_oil	meangap_lfp_oilBCS	sdgap_lfp_oilBCS	count_lfp_oilBCS	countn_lfp_oilBCS	meangap_lfp_fin	sdgap_lfp_fin	count_lfp_fin	countn_lfp_fin	meangap_lfp_finBCS	sdgap_lfp_finBCS	count_lfp_finBCS	countn_lfp_finBCS	meangap_lfp_disinfl	sdgap_lfp_disinfl	count_lfp_disinfl	countn_lfp_disinfl	meangap_lfp_length	sdgap_lfp_length	count_lfp_length	countn_lfp_length	meangap_lfp_depth	sdgap_lfp_depth	count_lfp_depth	countn_lfp_depth	meangap_emprate_infl	sdgap_emprate_infl	count_emprate_infl	countn_emprate_infl	meangap_emprate_oil	sdgap_emprate_oil	count_emprate_oil	countn_emprate_oil	meangap_emprate_oilBCS	sdgap_emprate_oilBCS	count_emprate_oilBCS	countn_emprate_oilBCS	meangap_emprate_fin	sdgap_emprate_fin	count_emprate_fin	countn_emprate_fin	meangap_emprate_finBCS	sdgap_emprate_finBCS	count_emprate_finBCS	countn_emprate_finBCS	meangap_emprate_disinfl	sdgap_emprate_disinfl	count_emprate_disinfl	countn_emprate_disinfl	meangap_emprate_length	sdgap_emprate_length	count_emprate_length	countn_emprate_length	meangap_emprate_depth	sdgap_emprate_depth	count_emprate_depth	countn_emprate_depth	meanratio_gdp_infl	meanratio_gdp_oil	meanratio_gdp_oilBCS	meanratio_gdp_fin	meanratio_gdp_finBCS	meanratio_gdp_disinfl	meanratio_gdp_length	meanratio_gdp_depth, i(estwindow) j(gapstart) 

reshape wide meangap_gdp	sdgap_gdp	meanratio_gdp	meangap_emp	sdgap_emp	meanratio_emp	meangap_prod	sdgap_prod	meanratio_prod	meangap_wap	sdgap_wap	meanratio_wap	meangap_lfp	sdgap_lfp	meanratio_lfp	meangap_emprate	sdgap_emprate	meanratio_emprate	count_gdp	countn_gdp	meangap_gdp_infl	sdgap_gdp_infl	count_gdp_infl	countn_gdp_infl	meanratio_gdp_infl	meangap_gdp_oil	sdgap_gdp_oil	count_gdp_oil	countn_gdp_oil	meanratio_gdp_oil	meangap_gdp_oilBCS	sdgap_gdp_oilBCS	count_gdp_oilBCS	countn_gdp_oilBCS	meanratio_gdp_oilBCS	meangap_gdp_fin	sdgap_gdp_fin	count_gdp_fin	countn_gdp_fin	meanratio_gdp_fin	meangap_gdp_finBCS	sdgap_gdp_finBCS	count_gdp_finBCS	countn_gdp_finBCS	meanratio_gdp_finBCS	meangap_gdp_disinfl	sdgap_gdp_disinfl	count_gdp_disinfl	countn_gdp_disinfl	meanratio_gdp_disinfl	meangap_gdp_length	sdgap_gdp_length	count_gdp_length	countn_gdp_length	meanratio_gdp_length	meangap_gdp_depth	sdgap_gdp_depth	count_gdp_depth	countn_gdp_depth	meanratio_gdp_depth	meangap_emp_infl	sdgap_emp_infl	count_emp_infl	countn_emp_infl	meanratio_emp_infl	meangap_emp_oil	sdgap_emp_oil	count_emp_oil	countn_emp_oil	meanratio_emp_oil	meangap_emp_oilBCS	sdgap_emp_oilBCS	count_emp_oilBCS	countn_emp_oilBCS	meanratio_emp_oilBCS	meangap_emp_fin	sdgap_emp_fin	count_emp_fin	countn_emp_fin	meanratio_emp_fin	meangap_emp_finBCS	sdgap_emp_finBCS	count_emp_finBCS	countn_emp_finBCS	meanratio_emp_finBCS	meangap_emp_disinfl	sdgap_emp_disinfl	count_emp_disinfl	countn_emp_disinfl	meanratio_emp_disinfl	meangap_emp_length	sdgap_emp_length	count_emp_length	countn_emp_length	meanratio_emp_length	meangap_emp_depth	sdgap_emp_depth	count_emp_depth	countn_emp_depth	meanratio_emp_depth	meangap_prod_infl	sdgap_prod_infl	count_prod_infl	countn_prod_infl	meanratio_prod_infl	meangap_prod_oil	sdgap_prod_oil	count_prod_oil	countn_prod_oil	meanratio_prod_oil	meangap_prod_oilBCS	sdgap_prod_oilBCS	count_prod_oilBCS	countn_prod_oilBCS	meanratio_prod_oilBCS	meangap_prod_fin	sdgap_prod_fin	count_prod_fin	countn_prod_fin	meanratio_prod_fin	meangap_prod_finBCS	sdgap_prod_finBCS	count_prod_finBCS	countn_prod_finBCS	meanratio_prod_finBCS	meangap_prod_disinfl	sdgap_prod_disinfl	count_prod_disinfl	countn_prod_disinfl	meanratio_prod_disinfl	meangap_prod_length	sdgap_prod_length	count_prod_length	countn_prod_length	meanratio_prod_length	meangap_prod_depth	sdgap_prod_depth	count_prod_depth	countn_prod_depth	meanratio_prod_depth	meangap_wap_infl	sdgap_wap_infl	count_wap_infl	countn_wap_infl	meanratio_wap_infl	meangap_wap_oil	sdgap_wap_oil	count_wap_oil	countn_wap_oil	meanratio_wap_oil	meangap_wap_oilBCS	sdgap_wap_oilBCS	count_wap_oilBCS	countn_wap_oilBCS	meanratio_wap_oilBCS	meangap_wap_fin	sdgap_wap_fin	count_wap_fin	countn_wap_fin	meanratio_wap_fin	meangap_wap_finBCS	sdgap_wap_finBCS	count_wap_finBCS	countn_wap_finBCS	meanratio_wap_finBCS	meangap_wap_disinfl	sdgap_wap_disinfl	count_wap_disinfl	countn_wap_disinfl	meanratio_wap_disinfl	meangap_wap_length	sdgap_wap_length	count_wap_length	countn_wap_length	meanratio_wap_length	meangap_wap_depth	sdgap_wap_depth	count_wap_depth	countn_wap_depth	meanratio_wap_depth	meangap_lfp_infl	sdgap_lfp_infl	count_lfp_infl	countn_lfp_infl	meanratio_lfp_infl	meangap_lfp_oil	sdgap_lfp_oil	count_lfp_oil	countn_lfp_oil	meanratio_lfp_oil	meangap_lfp_oilBCS	sdgap_lfp_oilBCS	count_lfp_oilBCS	countn_lfp_oilBCS	meanratio_lfp_oilBCS	meangap_lfp_fin	sdgap_lfp_fin	count_lfp_fin	countn_lfp_fin	meanratio_lfp_fin	meangap_lfp_finBCS	sdgap_lfp_finBCS	count_lfp_finBCS	countn_lfp_finBCS	meanratio_lfp_finBCS	meangap_lfp_disinfl	sdgap_lfp_disinfl	count_lfp_disinfl	countn_lfp_disinfl	meanratio_lfp_disinfl	meangap_lfp_length	sdgap_lfp_length	count_lfp_length	countn_lfp_length	meanratio_lfp_length	meangap_lfp_depth	sdgap_lfp_depth	count_lfp_depth	countn_lfp_depth	meanratio_lfp_depth	meangap_emprate_infl	sdgap_emprate_infl	count_emprate_infl	countn_emprate_infl	meanratio_emprate_infl	meangap_emprate_oil	sdgap_emprate_oil	count_emprate_oil	countn_emprate_oil	meanratio_emprate_oil	meangap_emprate_oilBCS	sdgap_emprate_oilBCS	count_emprate_oilBCS	countn_emprate_oilBCS	meanratio_emprate_oilBCS	meangap_emprate_fin	sdgap_emprate_fin	count_emprate_fin	countn_emprate_fin	meanratio_emprate_fin	meangap_emprate_finBCS	sdgap_emprate_finBCS	count_emprate_finBCS	countn_emprate_finBCS	meanratio_emprate_finBCS	meangap_emprate_disinfl	sdgap_emprate_disinfl	count_emprate_disinfl	countn_emprate_disinfl	meanratio_emprate_disinfl	meangap_emprate_length	sdgap_emprate_length	count_emprate_length	countn_emprate_length	meanratio_emprate_length	meangap_emprate_depth	sdgap_emprate_depth	count_emprate_depth	countn_emprate_depth	meanratio_emprate_depth, i(estwindow) j(gapstart)

save FinalData4Yadj_gap_matrix_t.dta, replace

keep estwindow	meangap_gdp3	meangap_emp3	meangap_prod3	meangap_gdp4	meangap_emp4	meangap_prod4	meangap_gdp5	meangap_emp5	meangap_prod5	meangap_gdp6	meangap_emp6	meangap_prod6	meangap_gdp7	meangap_emp7	meangap_prod7	meangap_gdp8	meangap_emp8	meangap_prod8	meangap_gdp9	meangap_emp9	meangap_prod9	meangap_gdp10	meangap_emp10	meangap_prod10	meangap_gdp_disinfl3	meangap_emp_disinfl3	meangap_prod_disinfl3	meangap_gdp_disinfl4	meangap_emp_disinfl4	meangap_prod_disinfl4	meangap_gdp_disinfl5	meangap_emp_disinfl5	meangap_prod_disinfl5	meangap_gdp_disinfl6	meangap_emp_disinfl6	meangap_prod_disinfl6	meangap_gdp_disinfl7	meangap_emp_disinfl7	meangap_prod_disinfl7	meangap_gdp_disinfl8	meangap_emp_disinfl8	meangap_prod_disinfl8	meangap_gdp_disinfl9	meangap_emp_disinfl9	meangap_prod_disinfl9	meangap_gdp_disinfl10	meangap_emp_disinfl10	meangap_prod_disinfl10	meangap_gdp_oil3	meangap_emp_oil3	meangap_prod_oil3	meangap_gdp_oil4	meangap_emp_oil4	meangap_prod_oil4	meangap_gdp_oil5	meangap_emp_oil5	meangap_prod_oil5	meangap_gdp_oil6	meangap_emp_oil6	meangap_prod_oil6	meangap_gdp_oil7	meangap_emp_oil7	meangap_prod_oil7	meangap_gdp_oil8	meangap_emp_oil8	meangap_prod_oil8	meangap_gdp_oil9	meangap_emp_oil9	meangap_prod_oil9	meangap_gdp_oil10	meangap_emp_oil10	meangap_prod_oil10	meangap_gdp_fin3	meangap_emp_fin3	meangap_prod_fin3	meangap_gdp_fin4	meangap_emp_fin4	meangap_prod_fin4	meangap_gdp_fin5	meangap_emp_fin5	meangap_prod_fin5	meangap_gdp_fin6	meangap_emp_fin6	meangap_prod_fin6	meangap_gdp_fin7	meangap_emp_fin7	meangap_prod_fin7	meangap_gdp_fin8	meangap_emp_fin8	meangap_prod_fin8	meangap_gdp_fin9	meangap_emp_fin9	meangap_prod_fin9	meangap_gdp_fin10	meangap_emp_fin10	meangap_prod_fin10
save FinalData_adjgap_all.dta, replace 

forval nw = 4/10 {
forval ns = 3/10 { //change
erase FinalData4Yadj_gap_w`nw'_s`ns'.dta
}
}

***********************************************
use FinalData4Yadj_gap_disinfl_w4_s3.dta
forval nw = 4/10 {
forval ns = 3/10 { //change
append using FinalData4Yadj_gap_disinfl_w`nw'_s`ns'.dta
save FinalData4Yadj_gap_disinfl_w4_s3.dta, replace
*erase FinalData4Yadj_gap_w`nw'_s`ns'.dta
}
}

drop proddrop4Y	empdrop4Y	empratedrop4Y	lfpdrop4Y	wapdrop4Y negative recession_depthgdp recession_depthemp recession_depthprod episodeid gdpgap4Y gdpgap4Y_trend  gdpgapA4Y_trend gdpdropA4Y gdpdropAbis4Y gdpdrop4Y gdpdropA4Y_trend gdpdropAbis4Y_trend gdpgap12A4Y gdpgap27A4Y gdpgap20A4Y gdpgap12A4Y_trend gdpgap27A4Y_trend gdpgap20A4Y_trend diffextragdppeakA4Y nqmaxgdpdropA4Y diffextragdppeakA4Y_trend nqmaxgdpdropA4Y_trend empgap4Y  prodgap4Y  wapgap4Y wapgapA4Y lfpgap4Y lfpgapA4Y emprategap4Y emprategapA4Y lrgdp_duration Type_Distress Type_Systemic Type_Inflation Type_Oilprice lgdp_duration financialcrisis increasingoilprice increasinginflation intentionaldisinflation Type_DisInflation old_episode recessionlength recessiondepth gdpgap2712A4Y gdpgap2012A4Y gdpgap2712ratioA4Y gdpgap2012ratioA4Y gdpgap2712A4Y_trend gdpgap2012A4Y_trend gdpgap2712ratioA4Y_trend gdpgap2012ratioA4Y_trend line //infl oil oilBCS fin finBCS disinfl length depth
*drop in 1
save FinalData_adjgap_disinfl.dta, replace


forval nw = 4/10 {
forval ns = 3/10 { //change
erase FinalData4Yadj_gap_disinfl_w`nw'_s`ns'.dta
}
}


erase Data_prov.dta
erase Data_prov_bis.dta
erase Episode_id.dta
erase Episode_Included.dta
erase FinalData_c225_newbis.dta
erase FinalData_episode_false_and_drop.dta
erase FinalData_episode_recession.dta
erase numbers.dta
erase Type_recession.dta


/*
save FinalData4Yadj_gap_fin_matrix.dta, replace

*erase FinalData4Yadj_gap_w4_s3.dta

drop proddrop4Y	empdrop4Y	empratedrop4Y	lfpdrop4Y	wapdrop4Y	ratio_gdp	ratio_prod	ratio_emp	ratio_emprate	ratio_lfp	ratio_wap
drop gapend

*reshape wide meangap_gdp	sdgap_gdp	meangap_emp	sdgap_emp	meangap_prod	sdgap_prod	meangap_wap	sdgap_wap	meangap_lfp	sdgap_lfp	meangap_emprate	sdgap_emprate	count_gdp	countn_gdp	meanratio_gdp	meangap_gdp_infl	sdgap_gdp_infl	count_gdp_infl	countn_gdp_infl	meangap_gdp_oil	sdgap_gdp_oil	count_gdp_oil	countn_gdp_oil	meangap_gdp_oilBCS	sdgap_gdp_oilBCS	count_gdp_oilBCS	countn_gdp_oilBCS	meangap_gdp_fin	sdgap_gdp_fin	count_gdp_fin	countn_gdp_fin	meangap_gdp_finBCS	sdgap_gdp_finBCS	count_gdp_finBCS	countn_gdp_finBCS	meangap_gdp_disinfl	sdgap_gdp_disinfl	count_gdp_disinfl	countn_gdp_disinfl	meangap_gdp_length	sdgap_gdp_length	count_gdp_length	countn_gdp_length	meangap_gdp_depth	sdgap_gdp_depth	count_gdp_depth	countn_gdp_depth	meangap_emp_infl	sdgap_emp_infl	count_emp_infl	countn_emp_infl	meangap_emp_oil	sdgap_emp_oil	count_emp_oil	countn_emp_oil	meangap_emp_oilBCS	sdgap_emp_oilBCS	count_emp_oilBCS	countn_emp_oilBCS	meangap_emp_fin	sdgap_emp_fin	count_emp_fin	countn_emp_fin	meangap_emp_finBCS	sdgap_emp_finBCS	count_emp_finBCS	countn_emp_finBCS	meangap_emp_disinfl	sdgap_emp_disinfl	count_emp_disinfl	countn_emp_disinfl	meangap_emp_length	sdgap_emp_length	count_emp_length	countn_emp_length	meangap_emp_depth	sdgap_emp_depth	count_emp_depth	countn_emp_depth	meangap_prod_infl	sdgap_prod_infl	count_prod_infl	countn_prod_infl	meangap_prod_oil	sdgap_prod_oil	count_prod_oil	countn_prod_oil	meangap_prod_oilBCS	sdgap_prod_oilBCS	count_prod_oilBCS	countn_prod_oilBCS	meangap_prod_fin	sdgap_prod_fin	count_prod_fin	countn_prod_fin	meangap_prod_finBCS	sdgap_prod_finBCS	count_prod_finBCS	countn_prod_finBCS	meangap_prod_disinfl	sdgap_prod_disinfl	count_prod_disinfl	countn_prod_disinfl	meangap_prod_length	sdgap_prod_length	count_prod_length	countn_prod_length	meangap_prod_depth	sdgap_prod_depth	count_prod_depth	countn_prod_depth	meangap_wap_infl	sdgap_wap_infl	count_wap_infl	countn_wap_infl	meangap_wap_oil	sdgap_wap_oil	count_wap_oil	countn_wap_oil	meangap_wap_oilBCS	sdgap_wap_oilBCS	count_wap_oilBCS	countn_wap_oilBCS	meangap_wap_fin	sdgap_wap_fin	count_wap_fin	countn_wap_fin	meangap_wap_finBCS	sdgap_wap_finBCS	count_wap_finBCS	countn_wap_finBCS	meangap_wap_disinfl	sdgap_wap_disinfl	count_wap_disinfl	countn_wap_disinfl	meangap_wap_length	sdgap_wap_length	count_wap_length	countn_wap_length	meangap_wap_depth	sdgap_wap_depth	count_wap_depth	countn_wap_depth	meangap_lfp_infl	sdgap_lfp_infl	count_lfp_infl	countn_lfp_infl	meangap_lfp_oil	sdgap_lfp_oil	count_lfp_oil	countn_lfp_oil	meangap_lfp_oilBCS	sdgap_lfp_oilBCS	count_lfp_oilBCS	countn_lfp_oilBCS	meangap_lfp_fin	sdgap_lfp_fin	count_lfp_fin	countn_lfp_fin	meangap_lfp_finBCS	sdgap_lfp_finBCS	count_lfp_finBCS	countn_lfp_finBCS	meangap_lfp_disinfl	sdgap_lfp_disinfl	count_lfp_disinfl	countn_lfp_disinfl	meangap_lfp_length	sdgap_lfp_length	count_lfp_length	countn_lfp_length	meangap_lfp_depth	sdgap_lfp_depth	count_lfp_depth	countn_lfp_depth	meangap_emprate_infl	sdgap_emprate_infl	count_emprate_infl	countn_emprate_infl	meangap_emprate_oil	sdgap_emprate_oil	count_emprate_oil	countn_emprate_oil	meangap_emprate_oilBCS	sdgap_emprate_oilBCS	count_emprate_oilBCS	countn_emprate_oilBCS	meangap_emprate_fin	sdgap_emprate_fin	count_emprate_fin	countn_emprate_fin	meangap_emprate_finBCS	sdgap_emprate_finBCS	count_emprate_finBCS	countn_emprate_finBCS	meangap_emprate_disinfl	sdgap_emprate_disinfl	count_emprate_disinfl	countn_emprate_disinfl	meangap_emprate_length	sdgap_emprate_length	count_emprate_length	countn_emprate_length	meangap_emprate_depth	sdgap_emprate_depth	count_emprate_depth	countn_emprate_depth	meanratio_gdp_infl	meanratio_gdp_oil	meanratio_gdp_oilBCS	meanratio_gdp_fin	meanratio_gdp_finBCS	meanratio_gdp_disinfl	meanratio_gdp_length	meanratio_gdp_depth, i(estwindow) j(gapstart) 

reshape wide meangap_gdp	sdgap_gdp	meanratio_gdp	meangap_emp	sdgap_emp	meanratio_emp	meangap_prod	sdgap_prod	meanratio_prod	meangap_wap	sdgap_wap	meanratio_wap	meangap_lfp	sdgap_lfp	meanratio_lfp	meangap_emprate	sdgap_emprate	meanratio_emprate	count_gdp	countn_gdp	meangap_gdp_infl	sdgap_gdp_infl	count_gdp_infl	countn_gdp_infl	meanratio_gdp_infl	meangap_gdp_oil	sdgap_gdp_oil	count_gdp_oil	countn_gdp_oil	meanratio_gdp_oil	meangap_gdp_oilBCS	sdgap_gdp_oilBCS	count_gdp_oilBCS	countn_gdp_oilBCS	meanratio_gdp_oilBCS	meangap_gdp_fin	sdgap_gdp_fin	count_gdp_fin	countn_gdp_fin	meanratio_gdp_fin	meangap_gdp_finBCS	sdgap_gdp_finBCS	count_gdp_finBCS	countn_gdp_finBCS	meanratio_gdp_finBCS	meangap_gdp_disinfl	sdgap_gdp_disinfl	count_gdp_disinfl	countn_gdp_disinfl	meanratio_gdp_disinfl	meangap_gdp_length	sdgap_gdp_length	count_gdp_length	countn_gdp_length	meanratio_gdp_length	meangap_gdp_depth	sdgap_gdp_depth	count_gdp_depth	countn_gdp_depth	meanratio_gdp_depth	meangap_emp_infl	sdgap_emp_infl	count_emp_infl	countn_emp_infl	meanratio_emp_infl	meangap_emp_oil	sdgap_emp_oil	count_emp_oil	countn_emp_oil	meanratio_emp_oil	meangap_emp_oilBCS	sdgap_emp_oilBCS	count_emp_oilBCS	countn_emp_oilBCS	meanratio_emp_oilBCS	meangap_emp_fin	sdgap_emp_fin	count_emp_fin	countn_emp_fin	meanratio_emp_fin	meangap_emp_finBCS	sdgap_emp_finBCS	count_emp_finBCS	countn_emp_finBCS	meanratio_emp_finBCS	meangap_emp_disinfl	sdgap_emp_disinfl	count_emp_disinfl	countn_emp_disinfl	meanratio_emp_disinfl	meangap_emp_length	sdgap_emp_length	count_emp_length	countn_emp_length	meanratio_emp_length	meangap_emp_depth	sdgap_emp_depth	count_emp_depth	countn_emp_depth	meanratio_emp_depth	meangap_prod_infl	sdgap_prod_infl	count_prod_infl	countn_prod_infl	meanratio_prod_infl	meangap_prod_oil	sdgap_prod_oil	count_prod_oil	countn_prod_oil	meanratio_prod_oil	meangap_prod_oilBCS	sdgap_prod_oilBCS	count_prod_oilBCS	countn_prod_oilBCS	meanratio_prod_oilBCS	meangap_prod_fin	sdgap_prod_fin	count_prod_fin	countn_prod_fin	meanratio_prod_fin	meangap_prod_finBCS	sdgap_prod_finBCS	count_prod_finBCS	countn_prod_finBCS	meanratio_prod_finBCS	meangap_prod_disinfl	sdgap_prod_disinfl	count_prod_disinfl	countn_prod_disinfl	meanratio_prod_disinfl	meangap_prod_length	sdgap_prod_length	count_prod_length	countn_prod_length	meanratio_prod_length	meangap_prod_depth	sdgap_prod_depth	count_prod_depth	countn_prod_depth	meanratio_prod_depth	meangap_wap_infl	sdgap_wap_infl	count_wap_infl	countn_wap_infl	meanratio_wap_infl	meangap_wap_oil	sdgap_wap_oil	count_wap_oil	countn_wap_oil	meanratio_wap_oil	meangap_wap_oilBCS	sdgap_wap_oilBCS	count_wap_oilBCS	countn_wap_oilBCS	meanratio_wap_oilBCS	meangap_wap_fin	sdgap_wap_fin	count_wap_fin	countn_wap_fin	meanratio_wap_fin	meangap_wap_finBCS	sdgap_wap_finBCS	count_wap_finBCS	countn_wap_finBCS	meanratio_wap_finBCS	meangap_wap_disinfl	sdgap_wap_disinfl	count_wap_disinfl	countn_wap_disinfl	meanratio_wap_disinfl	meangap_wap_length	sdgap_wap_length	count_wap_length	countn_wap_length	meanratio_wap_length	meangap_wap_depth	sdgap_wap_depth	count_wap_depth	countn_wap_depth	meanratio_wap_depth	meangap_lfp_infl	sdgap_lfp_infl	count_lfp_infl	countn_lfp_infl	meanratio_lfp_infl	meangap_lfp_oil	sdgap_lfp_oil	count_lfp_oil	countn_lfp_oil	meanratio_lfp_oil	meangap_lfp_oilBCS	sdgap_lfp_oilBCS	count_lfp_oilBCS	countn_lfp_oilBCS	meanratio_lfp_oilBCS	meangap_lfp_fin	sdgap_lfp_fin	count_lfp_fin	countn_lfp_fin	meanratio_lfp_fin	meangap_lfp_finBCS	sdgap_lfp_finBCS	count_lfp_finBCS	countn_lfp_finBCS	meanratio_lfp_finBCS	meangap_lfp_disinfl	sdgap_lfp_disinfl	count_lfp_disinfl	countn_lfp_disinfl	meanratio_lfp_disinfl	meangap_lfp_length	sdgap_lfp_length	count_lfp_length	countn_lfp_length	meanratio_lfp_length	meangap_lfp_depth	sdgap_lfp_depth	count_lfp_depth	countn_lfp_depth	meanratio_lfp_depth	meangap_emprate_infl	sdgap_emprate_infl	count_emprate_infl	countn_emprate_infl	meanratio_emprate_infl	meangap_emprate_oil	sdgap_emprate_oil	count_emprate_oil	countn_emprate_oil	meanratio_emprate_oil	meangap_emprate_oilBCS	sdgap_emprate_oilBCS	count_emprate_oilBCS	countn_emprate_oilBCS	meanratio_emprate_oilBCS	meangap_emprate_fin	sdgap_emprate_fin	count_emprate_fin	countn_emprate_fin	meanratio_emprate_fin	meangap_emprate_finBCS	sdgap_emprate_finBCS	count_emprate_finBCS	countn_emprate_finBCS	meanratio_emprate_finBCS	meangap_emprate_disinfl	sdgap_emprate_disinfl	count_emprate_disinfl	countn_emprate_disinfl	meanratio_emprate_disinfl	meangap_emprate_length	sdgap_emprate_length	count_emprate_length	countn_emprate_length	meanratio_emprate_length	meangap_emprate_depth	sdgap_emprate_depth	count_emprate_depth	countn_emprate_depth	meanratio_emprate_depth, i(estwindow) j(gapstart)

save FinalData4Yadj_gap_fin_matrix_t.dta, replace

********************************************

